{*
* Template Prestashop BioCosmetic
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

<!-- MODULE Block new products -->
<div id="new-products_block_right" class="block products_block">
	<p class="title_block"><a href="{$link->getPageLink('new-products.php')}" title="{l s='New products' mod='blocknewproducts'}">{l s='New products' mod='blocknewproducts'}</a></p>
	<div class="block_content">
		{if $new_products !== false}
			<ul class="products clearfix">
			{foreach from=$new_products item=product name=myLoop}
				<li class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}">
					<a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}" class="product_image"><img class="replace-2x" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'medium')}" alt="{$product.name|escape:'html':'UTF-8'}" {if isset($imgMediumSize)}style="height:{$imgMediumSize.height}px;width:{$imgMediumSize.width}px"{/if} /></a>
					<div class="product_content">
						<p class="product_name"><a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}">{$product.name|truncate:35:'...'|escape:'html':'UTF-8'}</a></p>
						<p class="product_desc">{if $product.description_short}{$product.description_short|strip_tags:'UTF-8'|truncate:40:'...'}{/if}</p>
						{if isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
							<p class="product_price">{if !$priceDisplay}{displayWtPrice p=$product.price}{else}{displayWtPrice p=$product.price_tax_exc}{/if}</p>
							{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
								<div class="aeuc_block">{hook h="displayProductPriceBlock" product=$product type="price"}</div>
							{/if}
						{/if}
					</div>
				</li>
			{/foreach}
			</ul>
			<p class="lnk"><a href="{$link->getPageLink('new-products.php')}" title="{l s='All new products' mod='blocknewproducts'}" class="button_large">{l s='All new products' mod='blocknewproducts'}</a></p>
		{else}
			<p>{l s='No new products at this time' mod='blocknewproducts'}</p>
		{/if}
	</div>
</div>
<!-- /MODULE Block new products -->