/**
* Template Prestashop BioCosmetic
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

// Animate the opening of the branch (span.grower jQueryElement)
function openBranch(jQueryElement, noAnimation) {
	jQueryElement.addClass('OPEN').removeClass('CLOSE');
	if (noAnimation)
		jQueryElement.parent().find('ul:first').show();
	else
		jQueryElement.parent().find('ul:first').slideDown();
}

// Animate the closing of the branch (span.grower jQueryElement)
function closeBranch(jQueryElement, noAnimation) {
	jQueryElement.addClass('CLOSE').removeClass('OPEN');
	if (noAnimation)
		jQueryElement.parent().find('ul:first').hide();
	else
		jQueryElement.parent().find('ul:first').slideUp();
}

// Animate the closing or opening of the branch (ul jQueryElement)
function toggleBranch(jQueryElement, noAnimation) {
	if (jQueryElement.hasClass('OPEN'))
		closeBranch(jQueryElement, noAnimation);
	else
		openBranch(jQueryElement, noAnimation);
}

$(document).ready(function() {
	if (!$('ul.tree.dhtml').hasClass('dynamized')) { // To do not execute this script as much as it's called...
		$('ul.tree.dhtml ul').prev().before("<span class='grower OPEN'> </span>"); // Add growers to each ul.tree elements
		$('ul.tree.dhtml ul li:last-child, ul.tree.dhtml li:last-child').addClass('last'); // Dynamically add the '.last' class on each last item of a branch
		
		// Collapse every expanded branch
		$('ul.tree.dhtml span.grower.OPEN').addClass('CLOSE').removeClass('OPEN').parent().find('ul:first').hide();
		$('ul.tree.dhtml').show();
		
		// Open the tree for the selected branch
		$('ul.tree.dhtml .selected').parents().each(function() {
			if ($(this).is('ul'))
				toggleBranch($(this).prev().prev(), true);
		});
		toggleBranch($('ul.tree.dhtml .selected').prev(), true);
		
		// Add a fonction on clicks on growers
		$('ul.tree.dhtml span.grower').click(function() {
			toggleBranch($(this));
		});
		
		$('ul.tree.dhtml').addClass('dynamized'); // Mark this 'ul.tree' elements as already 'dynamized'
		$('ul.tree.dhtml').removeClass('dhtml');
	}
});