{*
* Template Prestashop 
*
* @author    VIRTUALDEV
* @copyright VIRTUALDEV
* @license   See PDF documentation
* @website   http://www.virtualdev.tn
*}

{capture name=path}<a href="{$link->getPageLink('my-account.php', true)}" title="{l s='My account'}">{l s='My account'}</a><span class="navigation-pipe">{$navigationPipe}</span>{l s='Your personal information'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}

<h1>{l s='Your personal information'}</h1>

{include file="$tpl_dir./errors.tpl"}

{if isset($confirmation) && $confirmation}
	<p class="success">
		{l s='Your personal information has been successfully updated.'}
		{if isset($pwd_changed)}<br />{l s='Your password has been sent to your e-mail :'} {$email}{/if}
	</p>
{else}
	<form action="{$link->getPageLink('identity.php', true)}" method="post" class="std">
		<fieldset>
			<p class="bold">{l s='Please be sure to update your personal information if it has changed.'}</p>
			<p class="radio">
				<span>{l s='Title'}</span>
				{if isset($genders)}
				{foreach from=$genders key=k item=gender}
					<input type="radio" name="id_gender" id="id_gender{$gender->id}" value="{$gender->id|intval}" {if isset($smarty.post.id_gender) && $smarty.post.id_gender == $gender->id}checked="checked"{/if} />
					<label for="id_gender{$gender->id}" class="top">{$gender->name}</label>
				{/foreach}
				{else}
				<input type="radio" id="id_gender1" name="id_gender" value="1" {if $smarty.post.id_gender == 1 OR !$smarty.post.id_gender}checked="checked"{/if} />
				<label for="id_gender1">{l s='Mr.'}</label>
				<input type="radio" id="id_gender2" name="id_gender" value="2" {if $smarty.post.id_gender == 2}checked="checked"{/if} />
				<label for="id_gender2">{l s='Ms.'}</label>
				{/if}
			</p>
			<p class="required text">
				<label for="lastname">{l s='Last name'}<sup>*</sup></label>
				<span><input type="text" name="lastname" id="lastname" value="{$smarty.post.lastname}" class="is_required validate" data-validate="isName" /></span>
			</p>
			<p class="required text">
				<label for="firstname">{l s='First name'}<sup>*</sup></label>
				<span><input type="text" id="firstname" name="firstname" value="{$smarty.post.firstname}" class="is_required validate" data-validate="isName" /></span>
			</p>
			<p class="required text">
				<label for="email">{l s='E-mail address'}<sup>*</sup></label>
				<span><input type="email" name="email" id="email" value="{$smarty.post.email}" class="is_required validate" data-validate="isEmail" /></span>
			</p>
			<p class="required text">
				<label for="old_passwd">{l s='Current Password'}<sup>*</sup></label>
				<span><input type="password" name="old_passwd" id="old_passwd" class="is_required validate" data-validate="isPasswd" /></span>
			</p>
			<p class="password">
				<label for="passwd">{l s='New Password'}</label>
				<span><input type="password" name="passwd" id="passwd" class="validate" data-validate="isPasswd" /></span>
			</p>
			<p class="password">
				<label for="confirmation">{l s='Confirmation'}</label>
				<span><input type="password" name="confirmation" id="confirmation" class="validate" data-validate="isPasswd" /></span>
			</p>
			<p class="select birthday">
				<span class="birth">{l s='Date of Birth'}</span>
				<select id="days" name="days">
					<option value="">-</option>
					{foreach from=$days item=v}
						<option value="{$v}" {if ($sl_day == $v)}selected="selected"{/if}>{$v}&nbsp;&nbsp;</option>
					{/foreach}
				</select>
				{*
					{l s='January'}
					{l s='February'}
					{l s='March'}
					{l s='April'}
					{l s='May'}
					{l s='June'}
					{l s='July'}
					{l s='August'}
					{l s='September'}
					{l s='October'}
					{l s='November'}
					{l s='December'}
				*}
				<select id="months" name="months">
					<option value="">-</option>
					{foreach from=$months key=k item=v}
						<option value="{$k}" {if ($sl_month == $k)}selected="selected"{/if}>{l s=$v}&nbsp;</option>
					{/foreach}
				</select>
				<select id="years" name="years">
					<option value="">-</option>
					{foreach from=$years item=v}
						<option value="{$v}" {if ($sl_year == $v)}selected="selected"{/if}>{$v}&nbsp;&nbsp;</option>
					{/foreach}
				</select>
			</p>
			{if !isset($newsletter) OR (isset($newsletter) && $newsletter)}
				<p class="checkbox">
					<input type="checkbox" id="newsletter" name="newsletter" value="1" {if isset($smarty.post.newsletter) && $smarty.post.newsletter == 1} checked="checked"{/if} />
					<label for="newsletter">{l s='Sign up for our newsletter'}{if isset($field_required)}{if array_key_exists('newsletter', $field_required)}<sup>*</sup>{/if}{/if}</label>
				</p>
			{/if}
			{if !isset($optin) OR (isset($optin) && $optin)}
				<p class="checkbox">
					<input type="checkbox" name="optin" id="optin" value="1" {if isset($smarty.post.optin) && $smarty.post.optin == 1} checked="checked"{/if} />
					<label for="optin">{l s='Receive special offers from our partners'}{if isset($field_required)}{if array_key_exists('optin', $field_required)}<sup>*</sup>{/if}{/if}</label>
				</p>
			{/if}
			<p class="submit">
				<input type="submit" class="button" name="submitIdentity" value="{l s='Save'}" />
			</p>
			<p class="required"><sup>*</sup>{l s='Required fields'}</p>
			<p id="security_informations">
				{l s='[Insert customer data privacy clause or law here, if applicable]'}
			</p>
		</fieldset>
	</form>
{/if}

<ul class="footer_links">
	<li><a href="{$link->getPageLink('my-account.php', true)}" title="{l s='Back to your account'}">{l s='Back to your account'}</a></li>
	<li><a href="{$base_dir_ssl}" title="{l s='Home'}">{l s='Home'}</a></li>
</ul>