$('document').ready(function(){

    if (Modernizr.touch)
    {
       var menuOpen = false;

        $('#wpmegamenu-main .root-item').on('touchstart', function(e){
            var self = e.target;

            if (!menuOpen) {
                menuOpen = true;
                showMegamenuMenu(self);
            }
            else if (menuOpen && !$(this).closest('.root').children('.menu-items').hasClass('active')) {
                hideMegamenuMenu();
                showMegamenuMenu(self);
            }
            else {
                menuOpen = false;
                hideMegamenuMenu();
            }
        });
    }
    else
    {
        $('#wpmegamenu-main .root').mouseover(function(e){
            $(this).doTimeout('wpmenuhover', 250, showMegamenuMenu, e.target);
        }).mouseout(function(){
            $(this).doTimeout('wpmenuhover', 250, hideMegamenuMenu);
        });
    }

    // Mobile menu open/close handles
    var $_expandElement = $('<span/>', { class: 'wpmegamenu-mobile-handle wpicon wpicon-plus small' });
    var clickHandler = 'click';
    if (Modernizr.touch) {
        clickHandler = 'touchstart';
    }

    $('#header_mobile_menu .wpmegamenu > ul > li').each(function(){
        if ($(this).children('.menu-items').length > 0 && $(this).children('.wpmegamenu-mobile-handle').length == 0){
            $(this).children('.root-item').after($_expandElement.clone());
        }
    });

    $('#header_mobile_menu .wpmegamenu .wpmegamenu-mobile-handle').on(clickHandler, function(e)
    {
        e.preventDefault();

        if ($(this).next('ul').length > 0)
        {
            if ($(this).next('ul').is(':visible')){
                $(this).next('ul').slideUp('fast');
                $(this).toggleClass('wpicon-plus wpicon-minus');
            } else {
                $(this).next('ul').slideDown('fast');
                $(this).toggleClass('wpicon-plus wpicon-minus');
            }
        }
    });

});

function showMegamenuMenu(el)
{
    // Calculate menu width (parent row width)
    var mWidth = $('#wpmegamenu-main').closest('.row').width();

    // Calculate correct top position for the menu

    // If sticky menu is active
    if ( $('#wpmegamenu-main').parents('#sticky-menu-wrapper').length > 0 ){
        var _stickyMenuOffset = $('#sticky-menu-wrapper').offset();
        var _stickyMenuHeight = $('#sticky-menu-wrapper').height();
        var _menuContainerOffset = $('#wpmegamenu-main').offset();
        var mTop = _stickyMenuOffset.top + _stickyMenuHeight - _menuContainerOffset.top;
    } else {
        var _headerBottomOffset = $('#header_bottom').offset();
        var _headerBottomHeight = $('#header_bottom').height();
        var _menuContainerOffset = $('#wpmegamenu-main').offset();
        var mTop = _headerBottomOffset.top + _headerBottomHeight - _menuContainerOffset.top;
    }

    // Calculate correct left position for the menu
    var _menuContainerRowOffset = $('#wpmegamenu-main').closest('.row').offset();
    var _menuContainerRowLeftPadding = parseInt( $('#wpmegamenu-main').closest('.row').css('padding-left') );
    var mLeft = _menuContainerRowOffset.left + _menuContainerRowLeftPadding - _menuContainerOffset.left;

    // Set the css of the menu
    $(el).closest('.root').children('.menu-items').css({ 'top' : mTop, 'width' : mWidth, 'left' : mLeft }).addClass('active').fadeIn(250);
}

function hideMegamenuMenu(){
    $('#wpmegamenu-main .menu-items.active').removeClass('active').fadeOut(250);
}