<?php

/* Withinpixels - Custom Footer Block - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

class WPCustomFooterBlock extends Module
{
    function __construct()
    {
        $this->name = 'wpcustomfooterblock';
        $this->tab = 'front_office_features';
        $this->version = '1.0';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('WithinPixels - Custom Footer Block');
        $this->description = $this->l('Adds custom HTML block to footer');
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()){
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
               && $this->registerHook('displayFooter')
               && $this->_createConfigs()
               && $this->_createTab();
    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {
        return parent::uninstall()
               && $this->unregisterHook('displayFooter')
               && $this->_deleteConfigs()
               && $this->_deleteTab();
    }

    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    private function _createTables()
    {
        return true;
    }

    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    private function _deleteTables()
    {
        return true;
    }

    /* ------------------------------------------------------------- */
    /*  CREATE CONFIGS
    /* ------------------------------------------------------------- */
    private function _createConfigs()
    {
        $languages = $this->context->language->getLanguages();

        foreach ($languages as $language){
            $customFooterBlockTitle[$language['id_lang']] = 'Custom footer block';
        }

        foreach ($languages as $language){
            $customFooterBlockContent[$language['id_lang']] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam eget sodales est, nec consequat elit. Fusce mollis gravida metus nec laoreet. Sed semper in velit eu iaculis. Praesent lobortis cursus viverra. Nulla dapibus est nibh, a aliquet tortor bibendum vitae. Morbi vitae laoreet urna, quis condimentum ligula. Fusce diam nulla, mattis posuere feugiat sit amet, sodales non dolor.';
        }

        $response = Configuration::updateValue('WPCUSTOMFOOTERBLOCK_TITLE', $customFooterBlockTitle, true);
        $response &= Configuration::updateValue('WPCUSTOMFOOTERBLOCK_CONTENT', $customFooterBlockContent, true);

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  DELETE CONFIGS
    /* ------------------------------------------------------------- */
    private function _deleteConfigs()
    {
        $response = Configuration::deleteByName('WPCUSTOMFOOTERBLOCK_TITLE');
        $response &= Configuration::deleteByName('WPCUSTOMFOOTERBLOCK_CONTENT');

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL DEMO DATA
    /* ------------------------------------------------------------- */
    private function _installDemoData()
    {
        return true;
    }

    /* ------------------------------------------------------------- */
    /*  CREATE THE TAB MENU
    /* ------------------------------------------------------------- */
    private function _createTab()
    {
        $response = true;

        // First check for parent tab
        $parentTabID = Tab::getIdFromClassName('AdminWP');

        if ($parentTabID) {
            $parentTab = new Tab($parentTabID);
        } else {
            $parentTab = new Tab();
            $parentTab->active = 1;
            $parentTab->name = array();
            $parentTab->class_name = "AdminWP";
            foreach (Language::getLanguages() as $lang){
                $parentTab->name[$lang['id_lang']] = "WithinPixels";
            }
            $parentTab->id_parent = 0;
            $parentTab->module = $this->name;
            $response &= $parentTab->add();
        }

        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = "AdminWPCustomFooterBlock";
        $tab->name = array();
        foreach (Language::getLanguages() as $lang){
            $tab->name[$lang['id_lang']] = "Custom Footer Block";
        }
        $tab->id_parent = $parentTab->id;
        $tab->module = $this->name;
        $response &= $tab->add();

        return $response;
    }


    /* ------------------------------------------------------------- */
    /*  DELETE THE TAB MENU
    /* ------------------------------------------------------------- */
    private function _deleteTab()
    {
        $id_tab = Tab::getIdFromClassName('AdminWPCustomFooterBlock');
        $parentTabID = Tab::getIdFromClassName('AdminWP');

        $tab = new Tab($id_tab);
        $tab->delete();

        // Get the number of tabs inside our parent tab
        // If there is no tabs, remove the parent
        $tabCount = Tab::getNbTabs($parentTabID);
        if ($tabCount == 0){
            $parentTab = new Tab($parentTabID);
            $parentTab->delete();
        }

        return true;
    }

    /* ------------------------------------------------------------- */
    /*  GET CONTENT
    /* ------------------------------------------------------------- */
    public function getContent()
    {
        $languages = $this->context->language->getLanguages();

        if (Tools::isSubmit('submit'.$this->name))
        {
            foreach ($languages as $language){
                if (Tools::isSubmit('wpcustomfooterblock_title_'.$language['id_lang'])){
                    $customFooterBlockTitle[$language['id_lang']] = Tools::getValue('wpcustomfooterblock_title_'.$language['id_lang']);
                }

                if (Tools::isSubmit('wpcustomfooterblock_content_'.$language['id_lang'])){
                    $customFooterBlockContent[$language['id_lang']] = Tools::getValue('wpcustomfooterblock_content_'.$language['id_lang']);
                }
            }

            Configuration::updateValue('WPCUSTOMFOOTERBLOCK_TITLE', $customFooterBlockTitle, true);
            Configuration::updateValue('WPCUSTOMFOOTERBLOCK_CONTENT', $customFooterBlockContent, true);
        }

        return $this->_displayForm();
    }

    /* ------------------------------------------------------------- */
    /*  DISPLAY CONFIGURATION FORM
    /* ------------------------------------------------------------- */
    private function _displayForm()
    {
        $id_default_lang = $this->context->language->id;
        $languages = $this->context->language->getLanguages();

        $fields_form = array(
            'wpcustomfooterblock-general' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Custom Footer Block Options'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'name' => 'wpcustomfooterblock_title',
                            'label' => $this->l('Block title'),
                            'required' => false,
                            'lang' => true,
                        ),
                        array(
                            'type' => 'textarea',
                            'name' => 'wpcustomfooterblock_content',
                            'label' => $this->l('Block content'),
                            'cols' => 136,
                            'rows' => 200,
                            'autoload_rte' => true,
                            'required' => false,
                            'lang' => true,
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveCustomFooterBlockOptions'
                    )
                )
            )
        );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $id_default_lang;
        $helper->allow_employee_form_lang = $id_default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit'.$this->name;

        foreach($languages as $language){
            $helper->languages[] = array(
                'id_lang' => $language['id_lang'],
                'iso_code' => $language['iso_code'],
                'name' => $language['name'],
                'is_default' => ($id_default_lang == $language['id_lang'] ? 1 : 0)
            );
        }

        foreach ($languages as $language) {
            $helper->fields_value['wpcustomfooterblock_title'][$language['id_lang']] = Tools::getValue('wpcustomfooterblock_title_'.$language['id_lang'], Configuration::get('WPCUSTOMFOOTERBLOCK_TITLE', $language['id_lang']));
            $helper->fields_value['wpcustomfooterblock_content'][$language['id_lang']] = Tools::getValue('wpcustomfooterblock_content_'.$language['id_lang'], Configuration::get('WPCUSTOMFOOTERBLOCK_CONTENT', $language['id_lang']));
        }

        return $helper->generateForm($fields_form);
    }


    /* ------------------------------------------------------------- */
    /*
    /*  FRONT OFFICE RELATED STUFF
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */

    private function _prepHook($params)
    {
        $id_default_lang = $this->context->language->id;

        $wpcustomfooterblock = array(
            'title' => Configuration::get('WPCUSTOMFOOTERBLOCK_TITLE', $id_default_lang),
            'content' => Configuration::get('WPCUSTOMFOOTERBLOCK_CONTENT', $id_default_lang)
        );

        $this->smarty->assign('wpcustomfooterblock', $wpcustomfooterblock);
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayFooter)
    /* ------------------------------------------------------------- */
    public function hookDisplayFooter($params)
    {
        $this->_prepHook($params);

        return $this->display(__FILE__, 'wpcustomfooterblock.tpl');
    }

}