<?php

/* Withinpixels - Blog Custom Block Module - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

class WPBlogRelatedPosts extends Module {

    private $_output = '';

    function __construct() {
                
        $this->name = 'wpblogrelatedposts';
        $this->tab = 'front_office_features';
        $this->version = '1.0';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Withinpixels - Blog Related Posts');
        $this->description = $this->l('Related blog posts block for product pages');

    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()){
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
               && $this->registerHook('displayHeader')
               && $this->registerHook('displayRightColumn')
               && $this->createConfig();
    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {

        return parent::uninstall()
               && $this->unregisterHook('displayHeader')
               && $this->unregisterHook('displayRightColumn')
               && $this->removeConfig();
    }

    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    protected function createTables()
    {
        return true;
    }

    
    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    protected function deleteTables()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE DATA
    /* ------------------------------------------------------------- */
    protected function installData()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE TAB
    /* ------------------------------------------------------------- */
    public function installTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE TAB
    /* ------------------------------------------------------------- */  
    public function uninstallTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  CREATE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function createConfig()
    {
        // Options
        $response = Configuration::updateValue('WPBLOG_RELPOSTS_COUNT', 5);

        return $response;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REMOVE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function removeConfig()
    {
        // Options
        $response = Configuration::deleteByName('WPBLOG_RELPOSTS_COUNT');

        return $response;
    }


    /* ------------------------------------------------------------- */
    /*  MODULE INITIALIZE & FORM SUBMIT CHECKs
    /* ------------------------------------------------------------- */
    public function getContent()
    {
        // Make sure wpblog module is installed and enabled
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            $this->_output = $this->displayError($this->l('This module requires "Withinpixels - Blog" module, make sure it is installed and enabled!'));
            return $this->_output;
        }

        $errors = array();

        if (Tools::isSubmit('submit'.$this->name)){

            // Count
            // Validate numeric value
            if (Tools::isSubmit('wpblog_relposts_count')){
                if (Validate::isInt(Tools::getValue('wpblog_relposts_count'))){
                    Configuration::updateValue('WPBLOG_RELPOSTS_COUNT', Tools::getValue('wpblog_relposts_count'));
                } else {
                    $errors[] = $this->l('Post count must be a numeric value!');
                }
            }

            // Prepare the output
            if (count($errors)){
                $this->_output .= $this->displayError(implode('<br />', $errors));
            } else {
                $this->_output .= $this->displayConfirmation($this->l('Configuration updated'));
            }

        }

        return $this->_output.$this->displayForm();
    }


    /* ------------------------------------------------------------- */
    /*  DISPLAY CONFIGURATION FORM
    /* ------------------------------------------------------------- */
    public function displayForm()
    {
        // Get default Language
        $id_default_lang = $this->context->language->id;

        $fields_form = array(
            'wpblogrelatedposts-genereal' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('General'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'label' => $this->l('Maximum number of related posts'),
                            'name' => 'wpblog_relposts_count',
                            'required' => true,
                            'lang' => false
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveOptions'
                    )
                )
            )
        );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $id_default_lang;
        $helper->allow_employee_form_lang = $id_default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' => array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
            )
        );

        // Load current values
        $helper->fields_value['wpblog_relposts_count'] = Configuration::get('WPBLOG_RELPOSTS_COUNT');

        return $helper->generateForm($fields_form);

    }

    /* ------------------------------------------------------------- */
    /*
    /* FRONT OFFICE
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */
    private function _prepHook($params)
    {
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            return false;
        }

        if (file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php') && file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostRelationModel.php') && file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostImages.php')){
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php');
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostRelationModel.php');
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostImages.php');
        } else {
            return false;
        }

        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;

        // First, take all the configuration
        $count = Configuration::get('WPBLOG_RELPOSTS_COUNT');

        $id_product = Tools::getValue('id_product');
        if (!$id_product){
            return false;
        }

        $postIDs =  WPBlogPostRelationModel::getBlogPostID($id_product, 1, $count);

        $posts = array();

        if (count($postIDs) > 0){
            foreach ($postIDs as $postID)
            {
                // Get the post
                $wpBlogPost = new WPBlogPostModel($postID['id_wpblog_posts'], $id_default_lang);

                // Check if we have rights to access
                if (!$wpBlogPost->isAccessGranted()){
                    continue;
                }

                $posts[$wpBlogPost->id_wpblog_posts]['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
                $posts[$wpBlogPost->id_wpblog_posts]['name'] = $wpBlogPost->name;
                $posts[$wpBlogPost->id_wpblog_posts]['teaser'] = $wpBlogPost->teaser;
                $posts[$wpBlogPost->id_wpblog_posts]['post'] = $wpBlogPost->post;

                // Grab stuff according to the post type
                if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
                    $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
                    if ($postImages){
                        $posts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $postImages[0]['filename'];
                    }
                } else {
                    $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
                    if ($featuredImage){
                        $posts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $featuredImage['filename'];
                    }
                }

                // Create a link to post
                $posts[$wpBlogPost->id_wpblog_posts]['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));

                // Format the dates
                $posts[$wpBlogPost->id_wpblog_posts]['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);
            }
        }

        $blogImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . 'wpblog/views/uploads/');

        $wpblogrelatedposts = array(
            'posts' => $posts,
            'blogImageDir' => $blogImageDir
        );

        $this->context->smarty->assign(
            array(
                'wpblogrelatedposts' => $wpblogrelatedposts
            )
        );

    }

    /* ------------------------------------------------------------- */
    /*  HOOK (displayLeftColumn)
    /* ------------------------------------------------------------- */
    public function hookDisplayRightColumn($params)
    {
        $this->_prepHook($params);
        return $this->display(__FILE__, 'wpblogrelatedposts.tpl');
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayHeader)
    /* ------------------------------------------------------------- */
    public function hookDisplayHeader($params)
    {
        $this->context->controller->addCSS($this->_path . 'views/css/hook/wpblogrelatedposts.css');
    }

}
