<?php

/* Withinpixels - Blog Custom Block Module - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

class WPBlogCustomBlockB extends Module {

    private $_customHooks = array();
    private $_output = '';

    function __construct() {
                
        $this->name = 'wpblogcustomblockb';
        $this->tab = 'front_office_features';
        $this->version = '1.0';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Withinpixels - Blog Custom Block B');
        $this->description = $this->l('Customizable block for blog posts');

        $this->_customHooks = array(
            1 => 'displayWPBlogSidebar'
        );
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()){
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
               && $this->registerHook('displayHeader')
               && $this->registerHook('displayHome')
               && $this->registerHook('displayLeftColumn')
               && $this->registerCustomHooks()
               && $this->createConfig();
    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {

        return parent::uninstall()
               && $this->unregisterHook('displayHeader')
               && $this->unregisterHook('displayHome')
               && $this->unregisterHook('displayLeftColumn')
               && $this->unregisterCustomHooks()
               && $this->removeConfig();
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REGISTER CUSTOM HOOKS
    /* ------------------------------------------------------------- */
    protected function registerCustomHooks()
    {
        $response = true;

        foreach ($this->_customHooks as $key => $name)
        {
            $hookId = Hook::getIdByName($name);
            if ($hookId){
                $this->registerHook($name);
                continue;
            }

            $newHook = new Hook();
            $newHook->name = $name;
            $newHook->title = $name;
            $newHook->live_edit = 0;
            $newHook->position = 1; // This is why we are doing this whole thing..
            $newHook->add();

            $newHookId = $newHook->id;

            if (!$newHookId){
                $response &= false;
            } else {
                $this->registerHook($name);
            }

        }

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  UNREGISTER CUSTOM HOOKS
    /* ------------------------------------------------------------- */
    protected function unregisterCustomHooks()
    {
        $response = true;

        foreach ($this->_customHooks as $key => $name){
            $response &= $this->unregisterHook($name);
        }

        return $response;
    }


    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    protected function createTables()
    {
        return true;
    }

    
    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    protected function deleteTables()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE DATA
    /* ------------------------------------------------------------- */
    protected function installData()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE TAB
    /* ------------------------------------------------------------- */
    public function installTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE TAB
    /* ------------------------------------------------------------- */  
    public function uninstallTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  CREATE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function createConfig()
    {
        $languages = $this->context->language->getLanguages();

        foreach ($languages as $language){
            $title[$language['id_lang']] = 'Custom Block B';
        }

        // Options
        $response = Configuration::updateValue('WPBLOG_BLOCKB_TITLE', $title);
        $response &= Configuration::updateValue('WPBLOG_BLOCKB_TYPE', 'random');
        $response &= Configuration::updateValue('WPBLOG_BLOCKB_FROM', 'all');
        $response &= Configuration::updateValue('WPBLOG_BLOCKB_COUNT', 4);

        return $response;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REMOVE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function removeConfig()
    {
        // Options
        $response = Configuration::deleteByName('WPBLOG_BLOCKB_TITLE');
        $response &= Configuration::deleteByName('WPBLOG_BLOCKB_TYPE');
        $response &= Configuration::deleteByName('WPBLOG_BLOCKB_FROM');
        $response &= Configuration::deleteByName('WPBLOG_BLOCKB_COUNT');

        return $response;
    }


    /* ------------------------------------------------------------- */
    /*  MODULE INITIALIZE & FORM SUBMIT CHECKs
    /* ------------------------------------------------------------- */
    public function getContent()
    {
        // Make sure wpblog module is installed and enabled
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            $this->_output = $this->displayError($this->l('This module requires "Withinpixels - Blog" module, make sure it is installed and enabled!'));
            return $this->_output;
        }

        $errors = array();

        if (Tools::isSubmit('submit'.$this->name)){

            $languages = $this->context->language->getLanguages();

            // Title
            foreach ($languages as $language){
                if (Tools::isSubmit('wpblog_blockb_title_'.$language['id_lang'])){
                    $title[$language['id_lang']] = Tools::getValue('wpblog_blockb_title_'.$language['id_lang']);
                }
            }
            if (isset($title) && $title) {
                Configuration::updateValue('WPBLOG_BLOCKB_TITLE', $title);
            }

            // Type
            if (Tools::isSubmit('wpblog_blockb_type')){
                Configuration::updateValue('WPBLOG_BLOCKB_TYPE', Tools::getValue('wpblog_blockb_type'));
            }

            // From
            if (Tools::isSubmit('wpblog_blockb_from')){
                Configuration::updateValue('WPBLOG_BLOCKB_FROM', Tools::getValue('wpblog_blockb_from'));
            }

            // Count
            // Validate numeric value
            if (Tools::isSubmit('wpblog_blockb_count')){
                if (Validate::isInt(Tools::getValue('wpblog_blockb_count'))){
                    Configuration::updateValue('WPBLOG_BLOCKB_COUNT', Tools::getValue('wpblog_blockb_count'));
                } else {
                    $errors[] = $this->l('Post count must be a numeric value!');
                }
            }

            // Prepare the output
            if (count($errors)){
                $this->_output .= $this->displayError(implode('<br />', $errors));
            } else {
                $this->_output .= $this->displayConfirmation($this->l('Configuration updated'));
            }

        }

        return $this->_output.$this->displayForm();
    }


    /* ------------------------------------------------------------- */
    /*  DISPLAY CONFIGURATION FORM
    /* ------------------------------------------------------------- */
    public function displayForm()
    {
        // Get default Language
        $id_default_lang = $this->context->language->id;
        $languages = $this->context->language->getLanguages();
        $id_shop = $this->context->shop->id;

        // Types
        $type = array(
            array(
                'value' => 'latest',
                'name' => $this->l('Latest')
            ),
            array(
                'value' => 'oldest',
                'name' => $this->l('Oldest')
            ),
            array(
                'value' => 'random',
                'name' => $this->l('Random')
            )
        );

        // From
        // Get Blog Categories
        $blogCategories[] = array(
            'name' => 'All',
            'value' => 'all'
        );

        $wpBlogCategory = new WPBlogCategoryModel;
        $categoryTree = $wpBlogCategory->renderBlogCategoryTree($id_shop, $id_default_lang, array(), false, true);

        foreach($categoryTree as $key => $category){
            $categoryTree[$key]['value'] = $categoryTree[$key]['id_wpblog_cats'];
            unset($categoryTree[$key]['id_wpblog_cats']);
        }

        $blogCategories = array_merge($blogCategories, $categoryTree);

        $fields_form = array(
            'wpblogcustomblockb-general' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('General'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'name' => 'wpblog_blockb_title',
                            'label' => $this->l('Block Title'),
                            'required' => false,
                            'lang' => true,
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('Show:'),
                            'name' => 'wpblog_blockb_type',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $type,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('From:'),
                            'name' => 'wpblog_blockb_from',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $blogCategories,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Number of posts'),
                            'name' => 'wpblog_blockb_count',
                            'required' => true,
                            'lang' => false
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveOptions'
                    )
                )
            )
        );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $id_default_lang;
        $helper->allow_employee_form_lang = $id_default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' => array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
            )
        );

        foreach($languages as $language){
            $helper->languages[] = array(
                'id_lang' => $language['id_lang'],
                'iso_code' => $language['iso_code'],
                'name' => $language['name'],
                'is_default' => ($id_default_lang == $language['id_lang'] ? 1 : 0)
            );
        }

        // Load current values
        foreach ($languages as $language) {
            $helper->fields_value['wpblog_blockb_title'][$language['id_lang']] = Tools::getValue('wpblog_blockb_title_'.$language['id_lang'], Configuration::get('WPBLOG_BLOCKB_TITLE', $language['id_lang']));
        }

        $helper->fields_value['wpblog_blockb_type'] = Configuration::get('WPBLOG_BLOCKB_TYPE');
        $helper->fields_value['wpblog_blockb_from'] = Configuration::get('WPBLOG_BLOCKB_FROM');
        $helper->fields_value['wpblog_blockb_count'] = Configuration::get('WPBLOG_BLOCKB_COUNT');

        return $helper->generateForm($fields_form);

    }

    /* ------------------------------------------------------------- */
    /*
    /* FRONT OFFICE
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */
    private function _prepHook($params)
    {
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            return false;
        }

        if (file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php') && file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostImages.php')){
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php');
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostImages.php');
        } else {
            return false;
        }

        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;

        // First, take all the configuration
        $category = Configuration::get('WPBLOG_BLOCKB_FROM');
        $type = Configuration::get('WPBLOG_BLOCKB_TYPE');
        $count = Configuration::get('WPBLOG_BLOCKB_COUNT');

        if ($type == 'latest'){
            $orderBy = 'date_add';
            $orderWay = 'DESC';
        } elseif ($type == 'oldest'){
            $orderBy = 'date_add';
            $orderWay = 'ASC';
        } elseif ($type == 'random'){
            $orderBy = 'random';
            $orderWay = null;
        }

        if ($category == 'all'){
            $category = null;
        }

        $postIDs = WPBlogPostModel::getBlogPostIDs($category, $id_shop, 0, $count, true, $orderBy, $orderWay, false);

        $posts = array();

        if (count($postIDs) > 0){
            foreach ($postIDs as $postID)
            {
                // Get the post
                $wpBlogPost = new WPBlogPostModel($postID['id_wpblog_posts'], $id_default_lang);

                // Check if we have rights to access
                if (!$wpBlogPost->isAccessGranted()){
                    continue;
                }

                $posts[$wpBlogPost->id_wpblog_posts]['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
                $posts[$wpBlogPost->id_wpblog_posts]['name'] = $wpBlogPost->name;
                $posts[$wpBlogPost->id_wpblog_posts]['teaser'] = $wpBlogPost->teaser;
                $posts[$wpBlogPost->id_wpblog_posts]['post'] = $wpBlogPost->post;

                // Grab stuff according to the post type
                if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
                    $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
                    if ($postImages){
                        $posts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $postImages[0]['filename'];
                    }
                } elseif ($wpBlogPost->type == 'standard') {
                    $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
                    if ($featuredImage){
                        $posts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $featuredImage['filename'];
                    }
                } elseif ($wpBlogPost->type == 'video') {
                    $posts[$wpBlogPost->id_wpblog_posts]['video_embed'] = $wpBlogPost->video_embed;
                }

                // Create a link to post
                $posts[$wpBlogPost->id_wpblog_posts]['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));

                // Format the dates
                $posts[$wpBlogPost->id_wpblog_posts]['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);
            }
        }

        $blogImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . 'wpblog/views/uploads/');

        $wpblogcustomblockb = array(
            'title' => Configuration::get('WPBLOG_BLOCKB_TITLE', $id_default_lang),
            'posts' => $posts,
            'blogImageDir' => $blogImageDir,
            'blogLink' => $this->context->link->getModuleLink('wpblog', 'blog')
        );

        $this->context->smarty->assign(
            array(
                'wpblogcustomblockb' => $wpblogcustomblockb
            )
        );

    }

    /* ------------------------------------------------------------- */
    /*  HOOK (displayLeftColumn)
    /* ------------------------------------------------------------- */
    public function hookDisplayLeftColumn($params)
    {
        $this->_prepHook($params);
        return $this->display(__FILE__, 'wpblogcustomblockb-sidebar.tpl');
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayWPBlogSidebar)
    /* ------------------------------------------------------------- */
    public function hookDisplayWPBlogSidebar($params)
    {
        return $this->hookDisplayLeftColumn($params);
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayHome)
    /* ------------------------------------------------------------- */
    public function hookDisplayHome($params)
    {
        $this->_prepHook($params);
        return $this->display(__FILE__, 'wpblogcustomblockb-home.tpl');
    }

    /* ------------------------------------------------------------- */
    /*  HOOK (displayHeader)
    /* ------------------------------------------------------------- */
    public function hookDisplayHeader($params)
    {
        $this->context->controller->addCSS($this->_path . 'views/css/hook/wpblogcustomblockb.css');
    }

}
