<?php

/* Withinpixels - Blog Archives Module - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

class WPBlogArchives extends Module {

    private $_customHooks = array();

    function __construct() {
                
        $this->name = 'wpblogarchives';
        $this->tab = 'front_office_features';
        $this->version = '1.0';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Withinpixels - Blog Archives');
        $this->description = $this->l('Blog archive dates for sidebar');

        $this->_customHooks = array(
            1 => 'displayWPBlogSidebar'
        );
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()){
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
               && $this->registerHook('displayHeader')
               && $this->registerHook('displayLeftColumn')
               && $this->registerCustomHooks();
    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {

        return parent::uninstall()
               && $this->unregisterHook('displayHeader')
               && $this->unregisterHook('displayLeftColumn')
               && $this->unregisterCustomHooks();
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REGISTER CUSTOM HOOKS
    /* ------------------------------------------------------------- */
    protected function registerCustomHooks()
    {
        $response = true;

        foreach ($this->_customHooks as $key => $name)
        {
            $hookId = Hook::getIdByName($name);
            if ($hookId){
                $this->registerHook($name);
                continue;
            }

            $newHook = new Hook();
            $newHook->name = $name;
            $newHook->title = $name;
            $newHook->live_edit = 0;
            $newHook->position = 1; // This is why we are doing this whole thing..
            $newHook->add();

            $newHookId = $newHook->id;

            if (!$newHookId){
                $response &= false;
            } else {
                $this->registerHook($name);
            }

        }

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  UNREGISTER CUSTOM HOOKS
    /* ------------------------------------------------------------- */
    protected function unregisterCustomHooks()
    {
        $response = true;

        foreach ($this->_customHooks as $key => $name){
            $response &= $this->unregisterHook($name);
        }

        return $response;
    }


    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    protected function createTables()
    {
        return true;
    }

    
    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    protected function deleteTables()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE DATA
    /* ------------------------------------------------------------- */
    protected function installData()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE TAB
    /* ------------------------------------------------------------- */
    public function installTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE TAB
    /* ------------------------------------------------------------- */  
    public function uninstallTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  CREATE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function createConfig()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REMOVE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function removeConfig()
    {
        return true;
    }


    /* ------------------------------------------------------------- */
    /*
    /* FRONT OFFICE
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */
    private function _prepHook($params)
    {
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            return false;
        }

        if (file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php')){
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php');
        } else {
            return false;
        }

        $id_shop = $this->context->shop->id;

        $rawArchives = WPBlogPostModel::getArchiveInfo($id_shop);

        $blogArchives = array();
        if ($rawArchives){
            foreach ($rawArchives as $rawArchive)
            {
                $month = date('F', mktime(0, 0, 0, $rawArchive['MONTH'], 1));

                $rawArchive['MONTH'] = sprintf("%02s", $rawArchive['MONTH']);

                $blogArchives[$rawArchive['YEAR']][$month] = array(
                     'count' => $rawArchive['COUNT'],
                     'link' => $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $rawArchive['YEAR'], 'month' => $rawArchive['MONTH']))
                );
            }
        }

        if (empty($blogArchives)){
            $blogArchives = false;
        }

        $this->smarty->assign('blogArchives', $blogArchives);

        if (Tools::getValue('controller') == 'archive' && Tools::getValue('year') && Tools::getValue('month')){
            // We are in the blog archive pages
            $this->smarty->assign(
                array(
                    'archive_current_year' => Tools::getValue('year'),
                    'archive_current_month' => Tools::getValue('month')
                )
            );
        }
    }

    /* ------------------------------------------------------------- */
    /*  HOOK (displayLeftColumn)
    /* ------------------------------------------------------------- */
    public function hookDisplayLeftColumn($params)
    {
        $this->_prepHook($params);
        return $this->display(__FILE__, 'wpblogarchives.tpl');
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayWPBlogSidebar)
    /* ------------------------------------------------------------- */
    public function hookDisplayWPBlogSidebar($params)
    {
        return $this->hookDisplayLeftColumn($params);
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayHeader)
    /* ------------------------------------------------------------- */
    public function hookDisplayHeader($params)
    {
        $this->context->controller->addCSS($this->_path . 'views/css/hook/wpblogarchives.css');
        $this->context->controller->addJqueryPlugin('wpblogarchives', $this->_path . 'views/js/hook/');
    }

}
