{if (isset($wp_restricted_access) && $wp_restricted_access)}
    {capture name=path}
        <a href="{$link->getModuleLink('wpblog', 'blog')|escape:'html':'UTF-8'}">{l s='Blog' mod='wpblog'}</a>
    {/capture}

    <div class="alert alert-danger"><p>{l s='You do not have permission to view this category!' mod='wpblog'}</p></div>
{else}

    {capture name=path}
        <a href="{$link->getModuleLink('wpblog', 'blog')|escape:'html':'UTF-8'}">{l s='Blog'}</a><span class="navigation-pipe">{$navigationPipe}</span><span class="navigation_page">{$categoryName}</span>
    {/capture}

    {if (isset($categoryDesc) && $categoryDesc)}
        <div class="row wpblog-category-description">
            <div class="column col-12-12">{$categoryDesc}</div>
        </div>
    {/if}

    <div id="wpblog" class="row parent wpblog-category">

        {if isset($hook_displayWPBlogSidebar) && $hook_displayWPBlogSidebar != '' && isset($WPBLOG_CAT_SIDEBAR_POS) && $WPBLOG_CAT_SIDEBAR_POS == 'left'}
            {$contentClass = 'col-9-12 push-3-12'}
            {$sidebarClass = 'col-3-12 pull-9-12'}
        {elseif isset($hook_displayWPBlogSidebar) && $hook_displayWPBlogSidebar != '' && isset($WPBLOG_CAT_SIDEBAR_POS) && $WPBLOG_CAT_SIDEBAR_POS == 'right'}
            {$contentClass = 'col-9-12'}
            {$sidebarClass = 'col-3-12'}
        {else}
            {$contentClass = 'col-12-12'}
            {$sidebarClass = ''}
        {/if}

        <div class="row">
            <div class="wpblog-category-content column {$contentClass}">
                {if isset($posts) && $posts}

                    {include file="./category.tpl"}

                    <div class="wpblog-pagination">
                        {$pagination}
                    </div>
                {else}

                    <div class="alert alert-warning">{l s='There are no posts in this category!' mod='wpblog'}</div>

                {/if}
            </div>

            {*Custom hook for blog sidebar*}
            {if isset($hook_displayWPBlogSidebar) && $hook_displayWPBlogSidebar != ''}
                <div id="wpblog-sidebar" class="wpblog-category-sidebar column {$sidebarClass}">
                    {$hook_displayWPBlogSidebar}
                </div>
            {/if}
        </div>

    </div>

{/if}