{l s='First image will be the featured image of the blog post. If you want to change the featured image, you can re-position them by dragging and dropping.'}
<br />
<br />
{l s='Uploading multiple files at once can make your browser unresponsive for couple seconds, do NOT reload the page!'}
<br />
<br />
<br />
<br />

<div class="row">
    <div class="form-group">
        <label class="control-label col-lg-2 file_upload_label">
				<span class="label-tooltip" data-toggle="tooltip" title="{l s='Format:'} JPG, GIF, PNG. {l s='Filesize:'} {$max_image_size|string_format:"%.2f"} {l s='MB max.'}">
					{l s='Add image(s)'}
				</span>
        </label>
        <div class="col-lg-10">
            {$image_uploader}
        </div>
    </div>
</div>

<table class="table tableDnD" id="imageTable">
    <thead>
    <tr class="nodrag nodrop">
        <th class="fixed-width-lg"><span class="title_box">{l s='Image'}</span></th>
        <th class="fixed-width-xs"><span class="title_box">{l s='Position'}</span></th>
        <th></th>
    </tr>
    </thead>
    <tbody id="imageList">
    </tbody>
</table>

<table id="lineType" style="display:none;">
    <tr id="image_id">
        <td>
            <a href="{$module_dir}wpblog/views/uploads/image_filename.jpg" class="fancybox">
                <img src="{$module_dir}wpblog/views/uploads/image_filename-small.jpg" alt="legend" title="legend" class="img-thumbnail" />
            </a>
        </td>
        <td id="td_image_id" class="pointer dragHandle center positionImage">
            image_position
        </td>
        <td>
            <a href="#" class="delete_post_image pull-right btn btn-default" >
                <i class="icon-trash"></i> {l s='Delete this image'}
            </a>
        </td>
    </tr>
</table>

<script type="text/javascript">
    var upbutton = '{l s='Upload an image'}';
    var come_from = '{$table}';
    var success_add =  '{l s='The image has been successfully added.'}';
    var id_tmp = 0;

    var ThickboxI18nImage = "{l s='Image'}";
    var ThickboxI18nOf = "{l s='of'}";
    var ThickboxI18nClose = "{l s='Close'}";
    var ThickboxI18nOrEscKey = "{l s='(or "Esc")'}";
    var ThickboxI18nNext = "{l s='Next >'}";
    var ThickboxI18nPrev = "{l s='< Previous'}";
    var tb_pathToImage = "../img/loadingAnimation.gif";

    {literal}

    function imageLine(id, filename, position)
    {
        line = $("#lineType").html();
        line = line.replace(/image_id/g, id);
        line = line.replace(/image_filename/g, filename);
        line = line.replace(/image_position/g, position);
        line = line.replace(/<tbody>/gi, "");
        line = line.replace(/<\/tbody>/gi, "");

        $("#imageList").append(line);
    }

    //Ready Function
    $(document).ready(function()
    {
        {/literal}
            {foreach from=$images item=image}
                imageLine({$image->id}, '{$image->filename}', {$image->position});
            {/foreach}
        {literal}

        var originalOrder = false;

        $("#imageTable").tableDnD(
                {	onDragStart: function(table, row) {
                    originalOrder = $.tableDnD.serialize();
                },
                    onDrop: function(table, row) {
                        if (originalOrder != $.tableDnD.serialize()) {
                            current = $(row).attr("id");
                            stop = false;
                            image_up = "{";
                            $("#imageList").find("tr").each(function(i) {
                                $("#td_" +  $(this).attr("id")).html(i + 1);
                                if (!stop || (i + 1) == 2)
                                    image_up += '"' + $(this).attr("id") + '" : ' + (i + 1) + ',';
                            });
                            image_up = image_up.slice(0, -1);
                            image_up += "}";
                            updateImagePosition(image_up);
                        }
                    }
                });
        /**
         * on success function
         */
        function afterDeleteProductImage(data)
        {
            data = $.parseJSON(data);
            if (data)
            {
                id = data.id;
                if (data.status == 'ok'){
                    $("#" + id).remove();
                }
                $("#countImage").html(parseInt($("#countImage").html()) - 1);
                refreshImagePositions($("#imageTable"));
                showSuccessMessage(data.confirmations);
            }
        }

        function refreshImagePositions(imageTable)
        {
            var reg = /_[0-9]$/g;
            var up_reg  = new RegExp("imgPosition=[0-9]+&");

            imageTable.find("tbody tr").each(function(i,el) {
                $(el).find("td.positionImage").html(i + 1);
            });
            imageTable.find("tr td.dragHandle a:hidden").show();
            imageTable.find("tr td.dragHandle:first a:first").hide();
            imageTable.find("tr td.dragHandle:last a:last").hide();
        }


        $('.delete_post_image').die().live('click', function(e)
        {
            e.preventDefault();
            id = $(this).parent().parent().attr('id');
            if (confirm("{/literal}{l s='Are you sure?' js=1}{literal}"))
                doAdminAjax({
                    "action":"deletePostImage",
                    "id_wpblog_post_images" : id,
                    "token" : "{/literal}{$token}{literal}",
                    "tab" : "AdminWPBlogPosts",
                    "ajax" : 1 }, afterDeleteProductImage
                );
        });

        function updateImagePosition(json)
        {
            doAdminAjax({
                "action":"updateImagePosition",
                "json":json,
                "token" : "{/literal}{$token}{literal}",
                "tab" : "AdminWPBlogPosts",
                "ajax" : 1
            });
        }

        function delQueue(id)
        {
            $("#img" + id).fadeOut("slow");
            $("#img" + id).remove();
        }

        $('.fancybox').fancybox();
    });

    hideOtherLanguage(default_language);
    {/literal}
</script>