$(document).ready(function(){
    $('.reply-reset').hide();
    $('.comment-form-reply-title').hide();
    
    $('.fancybox').fancybox({
        'hideOnContentClick': true,
        'transitionIn'	: 'elastic',
        'transitionOut'	: 'elastic'
    });
    
    $('#wpblog-comments .reply-link').on('click', function(e){
        e.preventDefault();
        var replyToId = $(this).attr('data-replytoid');
        $('#commentReplyTo').val(replyToId);
        
        $('.comment-form-title').hide();
        $('.comment-form-reply-title').show();
        $('.reply-reset').show();
        
        var formTop = parseInt($('#wpblog-comment-form').offset().top);
        $('body').animate({ scrollTop: formTop }, '500', 'swing');
    });
        
    $('.reply-reset').on('click', function(e){
        e.preventDefault();
        $('#commentReplyTo').val(0);
        
        $('.comment-form-reply-title').hide();
        $('.reply-reset').hide();
        $('.comment-form-title').show();
    });

});

$(window).load(function()
{
    $('.post-slider').each(function()
    {
        var self = $(this);

        // Init carousel
        self.owlCarousel({
            slideSpeed: 250,
            paginationSpeed: 500,
            rewindSpeed: 600,
            autoHeight: true,
            rewindNav : false,
            singleItem: true,
            navigation : false,
            pagination: false,
            lazyEffect: false
        });

        self.closest('.post-slider-wrapper').find('.post-slider-nav-prev').on('click',function(){
            self.trigger('owl.prev');
        });

        self.closest('.post-slider-wrapper').find('.post-slider-nav-next').on('click',function(){
            self.trigger('owl.next');
        });

        $('.post-slider img').show();
    });

    $('.posts.masonry').packery({
        itemSelector : '.item'
    });

    $('#related-products').owlCarousel({
        itemsCustom: [ [0, 1], [379, 2], [419, 2], [479, 2], [639, 3], [767, 3], [959, 4], [1023, 4], [1279, 5], [1559, 5] ],
        responsiveRefreshRate: 50,
        slideSpeed: 200,
        paginationSpeed: 500,
        rewindSpeed: 600,
        rewindNav: true,
        pagination: true,
        navigation: false
    });
});