<?php

class wpBlogPostImages extends ObjectModel
{
    public $id_wpblog_post_images;
    public $id_wpblog_posts;
    public $position;
    public $filename;

    public static $definition = array(
        'table' => 'wpblog_post_images',
        'primary' => 'id_wpblog_post_images',
        'multilang' => false,
        'fields' => array(
            'id_wpblog_posts' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true),
            'position'        => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'filename'        => array('type' => self::TYPE_STRING),
        )
    );
    
    public function __construct($id_wpblog_post_images = null, $id_lang = null)
    {
        parent::__construct($id_wpblog_post_images, $id_lang);
        $this->image_dir = _PS_MODULE_DIR_ . 'wpblog/views/uploads/';
    }
    
    /*-------------------------------------------------------------*/
    /*  ADD
    /*-------------------------------------------------------------*/
    public function add($autodate = true, $null_values = false)
    {
        if ($this->position <= 0)
            $this->position = $this->getHighestPosition($this->id_wpblog_posts) + 1;

        return parent::add($autodate, $null_values);
    }
    
    /*-------------------------------------------------------------*/
    /*  DELETE
    /*-------------------------------------------------------------*/
    public function delete()
    {
        if (!parent::delete())
            return false;

        if (!$this->deletePostImage($this->filename)){
            return false;
        }
        
        // update positions
        $result = Db::getInstance()->executeS('
			SELECT *
			FROM `' . _DB_PREFIX_ . 'wpblog_post_images`
			WHERE `id_wpblog_posts` = ' . (int) $this->id_wpblog_posts . '
			ORDER BY `position`
		');
        
        $i = 1;
        if ($result){
            foreach ($result as $row){
                $row['position'] = $i++;
                Db::getInstance()->update($this->def['table'], $row, '`id_wpblog_post_images` = ' . (int) $row['id_wpblog_post_images'], 1);
            }
        }
        
        return true;
    }
    
    /*-------------------------------------------------------------*/
    /*  GET FEATURED IMAGE OF THE POST
    /*-------------------------------------------------------------*/
    public static function getFeaturedImage($id_wpblog_posts)
    {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'wpblog_post_images`
                WHERE `id_wpblog_posts` = ' . (int) $id_wpblog_posts . ' AND `position` = 1 ';

        return Db::getInstance()->getRow($sql);
    }
    
    /*-------------------------------------------------------------*/
    /*  GET ALL IMAGES
    /*-------------------------------------------------------------*/
    public static function getImages($id_wpblog_posts)
    {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'wpblog_post_images`
                WHERE `id_wpblog_posts` = ' . (int) $id_wpblog_posts . ' ORDER BY `position` ASC';

        return Db::getInstance()->executeS($sql);
    }
    
    /*-------------------------------------------------------------*/
    /*  GET TOTAL IMAGE COUNT
    /*-------------------------------------------------------------*/
    public static function getImagesTotal($id_wpblog_posts)
    {
        $result = Db::getInstance()->getRow('
		SELECT COUNT(`id_wpblog_post_images`) AS total
		FROM `' . _DB_PREFIX_ . 'wpblog_post_images`
		WHERE `id_wpblog_posts` = ' . (int) $id_wpblog_posts);
        return $result['total'];
    }
    
    /*-------------------------------------------------------------*/
    /*  GET HIGHEST POSITION
    /*-------------------------------------------------------------*/
    public static function getHighestPosition($id_wpblog_posts)
    {
        $result = Db::getInstance()->getRow('
		SELECT MAX(`position`) AS max
		FROM `' . _DB_PREFIX_ . 'wpblog_post_images`
		WHERE `id_wpblog_posts` = ' . (int) $id_wpblog_posts);
        return $result['max'];
    }
    
    /*-------------------------------------------------------------*/
    /*  UPDATE IMAGE POSITION
    /*-------------------------------------------------------------*/
    public function updatePosition($way, $position)
    {
        if (!$position)
            return false;

        // < and > statements rather than BETWEEN operator
        // since BETWEEN is treated differently according to databases
        $result = (Db::getInstance()->execute('
			UPDATE `' . _DB_PREFIX_ . 'wpblog_post_images`
			SET `position`= `position` ' . ($way ? '- 1' : '+ 1') . '
			WHERE `position`
			' . ($way ? '> ' . (int) $this->position . ' AND `position` <= ' . (int) $position : '< ' . (int) $this->position . ' AND `position` >= ' . (int) $position) . '
			AND `id_wpblog_posts`=' . (int) $this->id_wpblog_posts) && Db::getInstance()->execute('
			UPDATE `' . _DB_PREFIX_ . 'wpblog_post_images`
			SET `position` = ' . (int) $position . '
			WHERE `id_wpblog_post_images` = ' . (int) $this->id_wpblog_post_images));

        return $result;
    }

    /*-------------------------------------------------------------*/
    /*  DELETE POST IMAGE FROM SERVER
    /*-------------------------------------------------------------*/
    public function deletePostImage($filename)
    {
        // Delete images
        if (file_exists($this->image_dir . $filename . '.jpg')){
            $response = unlink($this->image_dir . $filename . '.jpg');
        }
        
        if (file_exists($this->image_dir . $filename . '-medium.jpg')){
            $response &= unlink($this->image_dir . $filename . '-medium.jpg');
        }
        
        if (file_exists($this->image_dir . $filename . '-small.jpg')){
            $response &= unlink($this->image_dir . $filename . '-small.jpg');
        } 
        
        if (file_exists($this->image_dir . $filename . '-smallsqr.jpg')){
            $response &= unlink($this->image_dir . $filename . '-smallsqr.jpg');
        } 
        
        if (!$response){
            return false;
        }
        
        return true;
    }

}
