<?php

class WPBlogCommentModel extends ObjectModel
{
    private $commentHierarchy = array();
    
    public $id_wpblog_post_comments;
    public $id_reply_to = 0;
    public $id_wpblog_posts;
    public $id_customer;
    public $name;
    public $email;
    public $comment;
    public $active = 1;
    public $ip;
    public $date_add;
    public $date_upd;
   
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'wpblog_post_comments',
        'primary' => 'id_wpblog_post_comments',
        'multilang' => false,
        'fields' => array(   
            //Fields
            'id_wpblog_post_comments' =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_reply_to'             =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_wpblog_posts'         =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_customer'             =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'name'                    =>  array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'size' => 250),
            'email'                   =>  array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'size' => 250),
            'comment'                 =>  array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'active'                  =>  array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'ip'                      =>  array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml', 'size' => 250),
            'date_add'                =>  array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd'                =>  array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        )
    );
        
    public function __construct($id_wpblog_post_comments = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id_wpblog_post_comments, $id_lang, $id_shop);        
    }

    /*-------------------------------------------------------------*/
    /*  GET COMMENTS BY POST ID
    /*-------------------------------------------------------------*/
    public function getComments($id_wpblog_posts, $withHierarchy = true)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT id_wpblog_post_comments, id_reply_to
            FROM '._DB_PREFIX_.'wpblog_post_comments
            WHERE id_wpblog_posts = '.$id_wpblog_posts.'
            AND active = 1'
            );
        
        if ($withHierarchy){
            $renderedComments = $this->renderComments($response);
            return $renderedComments;
        } else {
            return $response;
        }
    }

    /*-------------------------------------------------------------*/
    /*  RENDER COMMENT HIERARCHY
    /*-------------------------------------------------------------*/
    public function renderComments(&$comments, $parent = 0, $depth = 0)
    {
        foreach ($comments as $key => $comment) {
            if ($comment['id_reply_to'] == $parent){
                $wpBlogComment = new WPBlogCommentModel($comment['id_wpblog_post_comments']);
                
                $this->commentHierarchy[$comment['id_wpblog_post_comments']]['depth'] = $depth;
                $this->commentHierarchy[$comment['id_wpblog_post_comments']]['id'] = $wpBlogComment->id_wpblog_post_comments;
                $this->commentHierarchy[$comment['id_wpblog_post_comments']]['name'] = $wpBlogComment->name;
                $this->commentHierarchy[$comment['id_wpblog_post_comments']]['email'] = $wpBlogComment->email;
                $this->commentHierarchy[$comment['id_wpblog_post_comments']]['comment'] = $wpBlogComment->comment;
                $this->commentHierarchy[$comment['id_wpblog_post_comments']]['added'] = $wpBlogComment->date_add;
            
                unset($comments[$key]);
                $this->renderComments($comments, $comment['id_wpblog_post_comments'], $depth + 1);
            }
        }
        
        reset($comments);
        return $this->commentHierarchy;
    }

    /*-------------------------------------------------------------*/
    /*  GET COMMENTS COUNT BY POST ID
    /*-------------------------------------------------------------*/
    public static function getCommentsCount($id_wpblog_posts)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT COUNT(id_wpblog_post_comments)
            FROM '._DB_PREFIX_.'wpblog_post_comments
            WHERE id_wpblog_posts = '.$id_wpblog_posts.'
            AND active = 1'
        );

        return $response[0]['COUNT(id_wpblog_post_comments)'];
    }

    /*-------------------------------------------------------------*/
    /*  CHECK IF SAME USER ADDED SOMETHING TO THE SAME POST
    /*-------------------------------------------------------------*/
    public static function checkUserComments($id_wpblog_posts, $ip, $id_customer = 0)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow(
            'SELECT id_wpblog_post_comments, date_add
            FROM '._DB_PREFIX_.'wpblog_post_comments
            WHERE id_wpblog_posts = '.$id_wpblog_posts.'
            AND ip = "'.$ip.'"
            AND id_customer = '.$id_customer.'
            ORDER BY date_add DESC'
            );
            
        return $response;
    }

}
