<?php

require_once(dirname(__FILE__) . '/../custom/wpblogFrontController.php');

class wpblogarchiveModuleFrontController extends wpblogFrontController {

    private $year = null;
    private $month = 'all';
    
    // Template
    public $wpblog_template = 'archive/archive-layout.tpl';
            
    public function __construct() {
        parent::__construct();
    }

    public function initContent() {
        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        $blogImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . 'wpblog/views/uploads/');


        $pagination_needed = false;
        
        // Get year and month from url (year is required, month is optional)
        if (Tools::isSubmit('year') && Validate::isInt(Tools::getValue('year'))){
            $this->year = Tools::getValue('year');            
        } else {
            return false;
        }
        
        // If month is not submitted, we're going to set it to 'all'
        if (Tools::isSubmit('month')) {
            $this->month = Tools::getValue('month');
        } else {
            $_GET['month'] = $this->month;
        }
                
        // Fill page information
        $this->meta_title = $this->module->l('Blog posts from') . ' ' . $this->year . ($this->month ? '/'.$this->month : '');
        $this->meta_description = $this->module->l('Blog posts archive');
        
        // Get post count
        $postCount = WPBlogPostModel::getBlogPostIDsByDate($this->year, $this->month, $id_shop, 0, 0, true, null, 'DESC', true, true);

        // Get post limit per page, hard limit = 10 if there is something wrong with the configuration
        if (Configuration::get('WPBLOG_ARCHIVE_POST_LIMIT')){
            $limit = Configuration::get('WPBLOG_ARCHIVE_POST_LIMIT');
        } else {
            $limit = 10;
        }

        // Check if pagination is needed
        if ($postCount > $limit) {
            $pagination_needed = true;
        }
        
        // Calculate max page count
        $total_pages = (int) ceil($postCount / $limit);
        
        // Get page number from url, if the page number is not valid then do the -barrel roll-, I mean redirect...
        if (Tools::isSubmit('p') && Validate::isInt(Tools::getValue('p'))) {
            if (Tools::getValue('p') <= 0) {
                $this->doRedirect(1);
            } elseif(Tools::getValue('p') > $total_pages) {
                $this->doRedirect($total_pages);
            } else {
                $page = Tools::getValue('p');
            }
        } else {
            $page = 1;
        }
        
        // Calculate the start point
        $start = (int) (($page - 1) * $limit);

        // Get post ids according to the archive view type, timeline view won't obey sticky option
        if (Configuration::get('WPBLOG_ARCHIVE_VIEW') == 'timeline'){
            $postIDs = WPBlogPostModel::getBlogPostIDsByDate($this->year, $this->month, $id_shop, $start, $limit, true, null, null, false, false);
        } else {
            $postIDs = WPBlogPostModel::getBlogPostIDsByDate($this->year, $this->month, $id_shop, $start, $limit, true);
        }
        
        // If there are posts, then call them all from DB
        if (count($postIDs) > 0) {
            $posts = array();

            foreach ($postIDs as $postID)
            {
                // Get the post
                $wpBlogPost = new WPBlogPostModel($postID['id_wpblog_posts'], $id_default_lang, null);

                // If current user's group and post's group access intersecting, then add it to the array
                if (!$wpBlogPost->isAccessGranted()){
                    continue;
                }

                $posts[$wpBlogPost->id_wpblog_posts]['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
                $posts[$wpBlogPost->id_wpblog_posts]['name'] = $wpBlogPost->name;
                $posts[$wpBlogPost->id_wpblog_posts]['teaser'] = $wpBlogPost->teaser;
                $posts[$wpBlogPost->id_wpblog_posts]['post'] = $wpBlogPost->post;
                $posts[$wpBlogPost->id_wpblog_posts]['type'] = $wpBlogPost->type;
                $posts[$wpBlogPost->id_wpblog_posts]['grid_size'] = $wpBlogPost->grid_size;

                // Grab stuff according to the post type
                if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
                    $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
                    if ($postImages){
                        $posts[$wpBlogPost->id_wpblog_posts]['allImages'] = $postImages;
                    }
                } elseif ($wpBlogPost->type == 'standard') {
                    $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
                    if ($featuredImage){
                        $posts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $featuredImage['filename'];
                    }
                } elseif ($wpBlogPost->type == 'video') {
                    $posts[$wpBlogPost->id_wpblog_posts]['video_embed'] = $wpBlogPost->video_embed;
                }

                // Get the author name
                $employee = New Employee($wpBlogPost->id_author);
                $posts[$wpBlogPost->id_wpblog_posts]['author'] = $employee->firstname;

                // Format the date
                $posts[$wpBlogPost->id_wpblog_posts]['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);

                // Get the comment count
                $posts[$wpBlogPost->id_wpblog_posts]['comments_count'] = WPBlogCommentModel::getCommentsCount($wpBlogPost->id_wpblog_posts, $id_shop);

                // Create a link to post
                $posts[$wpBlogPost->id_wpblog_posts]['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));

            }
            
            // Get the pagination
            $pagination = new wpblogPagination();
            $pagination->pagination_type = 'archive';
            $pagination->page_keyword = 'archive';
            $pagination->context = $this->context;
            $pagination->current_page = $page;
            $pagination->total_pages = $total_pages;
            $pagination->year = $this->year;
            $pagination->month = $this->month;
            $paginationHTML = $pagination->createPagination();

            // Send stuff to the template
            $this->context->smarty->assign(
                array(
                    'posts'            => $posts,
                    'pagination'       => $paginationHTML,
                    'blogImageDir'     => $blogImageDir
                )
            );
        }

        // Assign hooks
        $hooks = array(
            'displayWPBlogSidebar'
        );

        foreach ($hooks as $hook){
            $this->context->smarty->assign('hook_'.$hook, Hook::exec($hook));
        }

        // Send more stuff to the template (these are will be available even if there isn't any post unlike the others)
        $this->context->smarty->assign(
            array(
                'archive_current_year' => $this->year,
                'archive_current_year_link' => $link = $this->context->link->getModuleLink('wpblog', 'archive', array('year'=>$this->year, 'month'=>'all')),
                'archive_current_month' => $this->month,
                'postCount' => $postCount,
                'WPBLOG_SHOW_AUTHOR' => Configuration::get('WPBLOG_SHOW_AUTHOR'),
                'WPBLOG_ARCHIVE_SIDEBAR_POS' => Configuration::get('WPBLOG_ARCHIVE_SIDEBAR_POS'),
                'WPBLOG_ARCHIVE_VIEW' => Configuration::get('WPBLOG_ARCHIVE_VIEW'),
                'WPBLOG_ARCHIVE_COLCOUNT' => Configuration::get('WPBLOG_ARCHIVE_COLCOUNT')
            )
        );

        parent::initContent();
    }

    private function doRedirect($page) {
        $link = $this->context->link->getModuleLink('wpblog', 'archive', array('year'=>$this->year, 'month'=>$this->month, 'p'=>$page));
        Tools::redirect($link);
    }

}
