<?php

class wpblogFrontController extends ModuleFrontController
{
    public $ssl = true;

    // Page info
    public $meta_title = '';
    public $meta_description = '';
    public $meta_keywords = '';
    
    public function __construct()
    {
        parent::__construct();

        $this->context = Context::getContext();

        include_once($this->module->getLocalPath().'models/wpBlogCategoryModel.php');
        include_once($this->module->getLocalPath().'models/wpBlogPostModel.php');
        include_once($this->module->getLocalPath().'models/wpBlogPostImages.php');
        include_once($this->module->getLocalPath().'controllers/custom/wpblogPagination.php');
        
    }
    
    public function initContent()
    {
        $this->display_column_left = false;
        $this->display_column_right = false;

        parent::initContent();

        // Set page name
        $controller_name = Dispatcher::getInstance()->getController();
        switch ($controller_name){
            case 'category' :
                $controller_name = 'wpblog-category';
                break;
            case 'archive' :
                $controller_name = 'wpblog-archive';
                break;
            case 'post' :
                $controller_name = 'wpblog-post';
                break;
            case 'blog' :
                $controller_name = 'wpblog-blog';
                break;
            case 'rss' :
                $controller_name = 'wpblog-rss';
                break;
            default :
                break;
        }

        $this->context->smarty->assign(array(
            'page_name' => $controller_name,
            'meta_title' => $this->meta_title,
            'meta_description' => $this->meta_description,
            'meta_keywords' => $this->meta_keywords
        ));
        
        $this->setTemplate($this->wpblog_template);
    }
    
    
    public function setMedia()
    {
        parent::setMedia();
        
        $this->addJqueryPlugin('fancybox');
		$this->addJqueryPlugin('wpblog', __PS_BASE_URI__.'modules/wpblog/views/js/front/');

		$this->addJS(__PS_BASE_URI__.'modules/wpblog/views/js/front/packery.pkgd.min.js');
        
        $this->addCSS(__PS_BASE_URI__.'modules/wpblog/views/css/front/wpblog.css');
    }
}