<?php

class AdminWPBlogPostsController extends ModuleAdminController
{
    
    public function __construct()
    {
        $this->className = 'WPBlogPostModel';
        $this->table = 'wpblog_posts';
		$this->meta_title = $this->l('WP Blog - Posts');
        $this->deleted = false;
   		$this->explicitSelect = true;
        $this->context = Context::getContext();
        $this->lang = true;
        $this->multiple_fieldsets = true;
        $this->bootstrap = true;

        $this->max_file_size = (int)(Configuration::get('PS_LIMIT_UPLOAD_FILE_VALUE') * 1000000);
		$this->max_image_size = (int)Configuration::get('PS_PRODUCT_PICTURE_MAX_SIZE');
        
        if (Shop::isFeatureActive()){
            Shop::addTableAssociation($this->table, array('type' => 'shop'));
        }
        
        $this->addRowAction('edit');
        $this->addRowAction('delete');
                
        $this->fields_list = array(
            'id_wpblog_posts' => array(
                'title' => $this->l('ID'),
                'type' => 'int',
                'align' => 'center',
                'width' => 25
            ),
            'name' => array(
                'title' => $this->l('Title'),
                'width' => 'auto',
            ),
            'type' => array(
                'title' => $this->l('Post Type'),
                'width' => 'auto',
            ),
            'date_add' => array(
                'title' => $this->l('Published On'),
                'width' => 'auto',
            ),
            'sticky' => array(
                'title' => $this->l('Sticky'),
                'width' => 70,
                'align' => 'center',
                'type' => 'bool',
                'icon' => array(
                    0 => 'icon-remove',
                    1 => 'icon-check',
                    'default' => 'icon-remove'
                ),
            ),
            'active' => array(
                'title' => $this->l('Status'),
                'width' => 70,
                'active' => 'status',
                'align' => 'center',
                'type' => 'bool'
            )
        );
                
        parent::__construct();
        
        require_once($this->module->getLocalPath().'models/wpBlogPostImages.php');

    }

    /* ------------------------------------------------------------- */
    /*  INIT PAGE HEADER TOOLBAR
    /* ------------------------------------------------------------- */
    public function initPageHeaderToolbar()
    {
        if (empty($this->display)){
            $this->page_header_toolbar_btn = array(
                'new' => array(
                    'href' => self::$currentIndex.'&addwpblog_posts&token='.$this->token,
                    'desc' => $this->l('Add New Post', null, null, false),
                    'icon' => 'process-icon-new'
                )
            );
        }

        parent::initPageHeaderToolbar();
    }

    /* ------------------------------------------------------------- */
    /*  INCLUDE NECESSARY FILES
    /* ------------------------------------------------------------- */
    public function setMedia()
    {
        parent::setMedia();

        if ( Validate::isLoadedObject($this->context->employee) && $this->context->employee->bo_theme ){
            $bo_theme = $this->context->employee->bo_theme;
        } else {
            $bo_theme = 'default';
        }

        if (!file_exists(_PS_BO_ALL_THEMES_DIR_.$bo_theme.DIRECTORY_SEPARATOR.'template')) {
            $bo_theme = 'default';
        }

        $this->addCSS(__PS_BASE_URI__.'modules/wpblog/views/css/admin/wpblog.css');

        $this->addJqueryUI(array('ui.core','ui.widget'));
		$this->addJqueryPlugin('tagify');
		$this->addJqueryPlugin('autocomplete');

        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('submitUpdate'.$this->table))
        {
            $this->addjQueryPlugin(array('thickbox','tablednd'));
            $this->addJs(__PS_BASE_URI__.$this->admin_webpath.'/themes/'.$bo_theme.'/js/jquery.iframe-transport.js');
            $this->addJs(__PS_BASE_URI__.$this->admin_webpath.'/themes/'.$bo_theme.'/js/jquery.fileupload.js');
            $this->addJs(__PS_BASE_URI__.$this->admin_webpath.'/themes/'.$bo_theme.'/js/jquery.fileupload-process.js');
            $this->addJs(__PS_BASE_URI__.$this->admin_webpath.'/themes/'.$bo_theme.'/js/jquery.fileupload-validate.js');
            $this->addJs(__PS_BASE_URI__.'js/vendor/spin.js');
            $this->addJs(__PS_BASE_URI__.'js/vendor/ladda.js');
        }
    }
       
    
    /* ------------------------------------------------------------- */
    /*  RENDER ADD/EDIT FORM
    /* ------------------------------------------------------------- */
    public function renderForm()
    {
        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        $languages = $this->context->language->getLanguages();
                                       
        /* Prepare group access */
        // If the object is available, we are editing the item
        if ($this->object && $this->object->group_access){
            $groupAccess = unserialize($this->object->group_access);

            foreach ($groupAccess as $groupAccessID => $value){
                $groupBox = 'groupBox_'.$groupAccessID;
                $this->fields_value[$groupBox] = $value;
            }
        } else {
            $groups = Group::getGroups($id_default_lang);
            $preselected = array(
                Configuration::get('PS_UNIDENTIFIED_GROUP'),
                Configuration::get('PS_GUEST_GROUP'),
                Configuration::get('PS_CUSTOMER_GROUP')
            );
            foreach ($groups as $group){
                $this->fields_value['groupBox_'.$group['id_group']] = (in_array($group['id_group'], $preselected));
            }
        }
        
        /* Prepare categories */
        $wpBlogCategory = new WPBlogCategoryModel;
        $categoryTree = $wpBlogCategory->renderBlogCategoryTree($id_shop, $id_default_lang);     
        
        // If the object is available, we are editing the item
        if ($this->object && $this->object->group_access){
            $selectedCategories = WPBlogPostModel::getBlogPostCategories($this->object->id);
            foreach ($selectedCategories as $key => $value){
                $categoryTree[$value['id_wpblog_cats']]['selected'] = true;
            }
        }

        /* Post types */
        $post_types = array(
            array(
                'id_type' => 'standard',
                'name' => 'Standard'
            ),
            array(
                'id_type' => 'gallery',
                'name' => 'Gallery'
            ),
            array(
                'id_type' => 'slider',
                'name' => 'Slider'
            ),
            array(
                'id_type' => 'video',
                'name' => 'Video'
            ),
        );
        
        /* Masonry options */
        $grid_sizes = array(
            array(
                'id' => 'single',
                'name' => 'Single'
            ),
            array(
                'id' => 'double',
                'name' => 'Double'
            )
        );
                
                
        // Init Fields form array
        $this->fields_form = array(
            'wpblog-general' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('General'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'name' => 'type',
                            'label' => $this->l('Post Type'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $post_types,
                                'id' => 'id_type',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'blogCategoryIds',
                            'label' => $this->l('Categories'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Displayed'),
                            'name' => 'active',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'active_on',
                                    'value' => 1,
                                    'label' => $this->l('Enabled')
                                ),
                                array(
                                    'id' => 'active_off',
                                    'value' => 0,
                                    'label' => $this->l('Disabled')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Sticky'),
                            'name' => 'sticky',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'sticky_on',
                                    'value' => 1,
                                    'label' => $this->l('Sticky')
                                ),
                                array(
                                    'id' => 'sticky_off',
                                    'value' => 0,
                                    'label' => $this->l('Not sticky')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Comments'),
                            'name' => 'comments',
                            'required' => false,
                            'class' => 't',
                            'is_bool' => true,
                            'desc' => $this->l('Enable or disable comments for this post'),
                            'values' => array(
                                array(
                                    'id' => 'comments_on',
                                    'value' => 1,
                                    'label' => $this->l('Enable')
                                ),
                                array(
                                    'id' => 'comments_off',
                                    'value' => 0,
                                    'label' => $this->l('Disable')
                                )
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            ),
            'wpblog-post' => array(
                'form' => array(
                    'tinymce' => true,
                    'legend' => array(
                        'title' => $this->l('Post'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'label' => $this->l('Title'),
                            'name' => 'name',
                            'desc' => $this->l('Must be less than 250 characters.'),
                            'size' => 50,
                            'class' => 'copy2friendlyUrl',
                            'required' => true,
                            'lang' => true
                        ),
                        array(
                            'type' => 'textarea',
                            'label' => $this->l('Teaser'),
                            'name' => 'teaser',
                            'cols' => 136,
                            'rows' => 8,
                            'desc' => $this->l('Post teaser.'),
                            'required' => false,
                            'lang' => true
                        ),
                        array(
                            'type' => 'textarea',
                            'label' => $this->l('Post'),
                            'name' => 'post',
                            'cols' => 136,
                            'rows' => 200,
                            'autoload_rte' => true,
                            'required' => true,
                            'lang' => true
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            ),
            'wpblog-post-seo' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('SEO'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'tags',
                            'label' => $this->l('Tags'),
                            'name' => 'tags',
                            'size' => 50,
                            'required' => false,
                            'lang' => true,
                            'desc' => $this->l('To add "tags," click in the field, write something, and then press "Enter."')
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Meta Title'),
                            'name' => 'meta_title',
                            'desc' => $this->l('This will override the post title if you fill. Must be less than 250 characters.'),
                            'size' => 50,
                            'required' => false,
                            'lang' => true
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Meta Description'),
                            'name' => 'meta_description',
                            'desc' => $this->l('Must be less than 250 characters.'),
                            'size' => 50,
                            'required' => false,
                            'lang' => true
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Friendly URL'),
                            'name' => 'link_rewrite',
                            'desc' => $this->l('Only letters and dash(-) allowed.'),
                            'size' => 50,
                            'required' => true,
                            'lang' => true
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            ),
            'wpblog-post-access' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Permissions'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'group',
                            'label' => $this->l('Group access:'),
                            'name' => 'groupBox',
                            'values' => Group::getGroups($id_default_lang),
                            'unidentified' => 'Unidetified',
                            'guest' => 'Guest',
                            'customer' => 'Customer',
                            'info_introduction' => $this->l('You now have three default customer groups.'),
                            'desc' => $this->l('Mark all of the customer groups you`d like to have access to this blog post.')
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            )
        );
        
        /* Relations */
        if (Tools::isSubmit('add'.$this->table) || Tools::isSubmit('submitAdd'.$this->table))
        {
            $this->fields_form['wpblog-post-related'] = array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Related Products'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'free',
                            'desc' => $this->l('You need to save the blog post to be able to add related products'),
                            'name' => 'product_autocomplete_save_before_add',
                            'size' => 50,
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            );
        }
        
        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('submitUpdate'.$this->table))
        {
            $this->fields_form['wpblog-post-related'] = array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Related Products'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'label' => $this->l('Add a related product'),
                            'name' => 'product_autocomplete',
                            'size' => 50,
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            );
        }

        /* Featured Image / Gallery */
        if (Tools::isSubmit('add'.$this->table) || Tools::isSubmit('submitAdd'.$this->table))
        {
            $this->fields_form['wpblog-gallery'] = array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Gallery / Featured Image'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'free',
                            'desc' => $this->l('You need to save the blog post to be able to add images'),
                            'name' => 'gallery_save_before_add',
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            );
        }

        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('submitUpdate'.$this->table))
        {
            $this->fields_form['wpblog-gallery'] = array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Gallery / Featured Image'),
                        'icon' => 'icon-cogs',
                        'description' => $this->l('Make sure you have selected "Gallery" as your post type, otherwise only the first image will be used as a featured image.'),
                    ),
                    'input' => array(
                        array(
                            'type' => 'file',
                            'multiple' => true,
                            'ajax' => true,
                            'name' => 'gallery_image',
                            'label' => $this->l('Add an image'),
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogPost'
                    )
                )
            );
        }
        
        /* Video */
        $this->fields_form['wpblog-video'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Video'),
                    'description' => $this->l('Make sure you have selected "Video" as your post type.'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Video'),
                        'name' => 'video_embed',
                        'desc' => $this->l('Video embed code. To be able to use embed codes, you need to enable "Allow iframes on HTML fields" option from Preferences > General page!'),
                        'cols' => 75,
                        'rows' => 7,
                        'required' => false,
                        'lang' => true
                    )
                ),
                // Submit Button
                'submit' => array(
                    'title' => $this->l('Save'),
                    'name' => 'saveBlogPost'
                )
            )
        );
        
        /* View Options */
        $this->fields_form['wpblog-view'] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('View Options'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'select',
                        'name' => 'grid_size',
                        'label' => $this->l('Post size'),
                        'required' => false,
                        'lang' => false,
                        'desc' => $this->l('Post size for category and archive view (Only for masonry and grid)'),
                        'options' => array(
                            'query' => $grid_sizes,
                            'id' => 'id',
                            'name' => 'name'
                        )
                    )
                ),
                // Submit Button
                'submit' => array(
                    'title' => $this->l('Save'),
                    'name' => 'saveBlogPost'
                )
            )
        );
            
        if (Shop::isFeatureActive()){
			$this->fields_form['wpblog-post-access']['form']['input'][] = array(
				'type' => 'shop',
				'label' => $this->l('Shop association'),
				'name' => 'checkBoxShopAsso',
			);
		}
        
        $this->tpl_form_vars = array(
            'PS_ALLOW_ACCENTED_CHARS_URL' => (int)Configuration::get('PS_ALLOW_ACCENTED_CHARS_URL'),
            'blogCategories' => $categoryTree,
            'max_image_size' => $this->max_image_size / 1024 / 1024
        );
        
        
        /* Get image stuff (if only we are editing the post) */
        if (Tools::isSubmit('update'.$this->table) || Tools::isSubmit('submitUpdate'.$this->table)){
            // Get image count
            $imageCount = wpBlogPostImages::getImagesTotal((int)$this->object->id);

            // Get images
            $images = wpBlogPostImages::getImages($this->object->id);
            foreach ($images as $k => $image){
               $images[$k] = new wpBlogPostImages($image['id_wpblog_post_images']);
            }

            // Get uploader
            $image_uploader = new HelperImageUploader('file');
            $image_uploader->setMultiple(!(Tools::getUserBrowser() == 'Apple Safari' && Tools::getUserPlatform() == 'Windows'))->setUseAjax(true)->setUrl(Context::getContext()->link->getAdminLink('AdminWPBlogPosts').'&ajax=1&id_wpblog_posts='.(int)$this->object->id.'&action=addPostImage');

            $this->tpl_form_vars['imageCount'] = $imageCount;
            $this->tpl_form_vars['id_wpblog_posts'] = $this->object->id;
            $this->tpl_form_vars['images'] = $images;
            $this->tpl_form_vars['image_uploader'] = $image_uploader->render();
            $this->tpl_form_vars['token'] =  $this->token;
            $this->tpl_form_vars['table'] = $this->table;

            // Get related products if available
            if (($obj = $this->loadObject(true))){
                $id_wpblog_posts = $obj->id_wpblog_posts;

                // Get product type relations
                $relatedProducts = WPBlogPostRelationModel::getBlogRelatedObjects($id_wpblog_posts, 1);

                if ($relatedProducts)
                {
                    $blog_related_products = array();

                    foreach ($relatedProducts as $relatedProduct) {
                        $product = new Product($relatedProduct['id_related_object'], false, $id_default_lang);
                        $blog_related_products[] = array(
                            'id' => $product->id,
                            'name' => $product->name,
                            'ref' => $product->reference
                        );
                    }

                    $this->tpl_form_vars['blog_related_products'] = $blog_related_products;
                }
            }
        }

        return parent::renderForm();
    }
    
    
    /* ------------------------------------------------------------- */
    /*  SAVE THE BLOG POST
    /* ------------------------------------------------------------- */
    public function processAdd()
    {
        $id_shop = $this->context->shop->id;
        $id_default_lang = $this->context->language->id;

        // Set the group access
        $groups = Group::getGroups($id_default_lang);
        $groupBox = array();
        $groupBox = Tools::getValue('groupBox');
        
        if (!$groupBox){
            foreach ($groups as $group){
                $access[$group['id_group']] = false;
            }
        } else {
            foreach ($groups as $group){
                $access[$group['id_group']] = in_array($group['id_group'], $groupBox);
            }
        }
        
        $access = serialize($access);
        $_POST['group_access'] = $access;
        
        // Set the author id
        $_POST['id_author'] = $this->context->employee->id;
        
		return parent::processAdd();
	}
    
    
    /* ------------------------------------------------------------- */
    /*  UPDATE THE BLOG POST
    /* ------------------------------------------------------------- */
    public function processUpdate()
    {
        $id_default_lang = $this->context->language->id;

        // Set the group access
        $groups = Group::getGroups($id_default_lang);
        $groupBox = array();
        $groupBox = Tools::getValue('groupBox');
        
        if (!$groupBox){
            foreach ($groups as $group){
                $access[$group['id_group']] = false;
            }
        } else {
            foreach ($groups as $group){
                $access[$group['id_group']] = in_array($group['id_group'], $groupBox);
            }
        }
        
        $access = serialize($access);
        $_POST['group_access'] = $access;
        
		return parent::processUpdate();
	}
    
    
    /* ------------------------------------------------------------- */
    /*
    /*  BLOG POST FEATURED IMAGE/GALLERY STUFF
    /*
    /* ------------------------------------------------------------- */
    
    /* ------------------------------------------------------------- */
    /*  ADD IMAGE
    /* ------------------------------------------------------------- */
    public function ajaxProcessAddPostImage()
    {
		self::$currentIndex = 'index.php?tab=AdminWPBlogPosts';

        // Set the image dir
        $image_dir = _PS_MODULE_DIR_ . 'wpblog/views/uploads/';

        $image_uploader = new HelperImageUploader('file');
        $image_uploader->setAcceptTypes(array('jpeg', 'gif', 'png', 'jpg'))->setMaxSize($this->max_image_size);
        $files = $image_uploader->process();

        foreach ($files as &$file)
        {
            // Create a db entry
            $wpBlogPostImage = new wpBlogPostImages();
            $wpBlogPostImage->id_wpblog_posts = Tools::getValue('id_wpblog_posts');
            $wpBlogPostImage->position = wpBlogPostImages::getHighestPosition(Tools::getValue('id_wpblog_posts')) + 1;
            $wpBlogPostImage->add();

            // Explode the file name
            $filenameParts = explode('.', $file['name']);

            // Prepare other destination files
            $destFiles = array(
                'base'     => $image_dir . $wpBlogPostImage->id . '-' . $wpBlogPostImage->id_wpblog_posts . '-' . $filenameParts[0] . '.jpg',
                'medium'   => $image_dir . $wpBlogPostImage->id . '-' . $wpBlogPostImage->id_wpblog_posts . '-' . $filenameParts[0] . '-medium.jpg',
                'small'    => $image_dir . $wpBlogPostImage->id . '-' . $wpBlogPostImage->id_wpblog_posts . '-' . $filenameParts[0] . '-small.jpg',
                'smallsqr' => $image_dir . $wpBlogPostImage->id . '-' . $wpBlogPostImage->id_wpblog_posts . '-' . $filenameParts[0] . '-smallsqr.jpg'
            );

            // Try to copy the image without modifying it
            if (!ImageManager::resize($file['save_path'], $destFiles['base'], null, null, 'jpg', false, $error))
            {
                switch ($error)
                {
                    case ImageManager::ERROR_FILE_NOT_EXIST :
                        $file['error'] = Tools::displayError('An error occurred while copying image, the file does not exist anymore.');
                        $wpBlogPostImage->delete();
                        break;

                    case ImageManager::ERROR_FILE_WIDTH :
                        $file['error'] = Tools::displayError('An error occurred while copying image, the file width is 0px.');
                        $wpBlogPostImage->delete();
                        break;

                    case ImageManager::ERROR_MEMORY_LIMIT :
                        $file['error'] = Tools::displayError('An error occurred while copying image, check your memory limit.');
                        $wpBlogPostImage->delete();
                        break;

                    default:
                        $file['error'] = Tools::displayError('An error occurred while copying image.');
                        $wpBlogPostImage->delete();
                        break;
                }
                continue;
            }
            else
            {
                // Update the db
                $wpBlogPostImage->filename = $wpBlogPostImage->id . '-' . $wpBlogPostImage->id_wpblog_posts . '-' . $filenameParts[0];
                $wpBlogPostImage->update();

                // Get original image info
                $baseImageInfo = getimagesize($destFiles['base']);
                list ($src_width, $src_height, $type) = $baseImageInfo;

                // Medium sized image (width: 900px)
                $aspectRatio = $src_width / 900;
                $mediumImageDimensions['width'] = 900;
                $mediumImageDimensions['height'] = floor($src_height / $aspectRatio);
                $mediumImage = ImageManager::resize($file['save_path'], $destFiles['medium'], $mediumImageDimensions['width'], $mediumImageDimensions['height']);


                // Small sized image (width: 500px)
                $aspectRatio = $src_width / 500;
                $smallImageDimensions['width'] = 500;
                $smallImageDimensions['height'] = floor($src_height / $aspectRatio);
                $smallImage = ImageManager::resize($file['save_path'], $destFiles['small'], $smallImageDimensions['width'], $smallImageDimensions['height']);


                // Small square image (crop from center)
                $sqr_wh = 350;

                // First, we need to figure out what is the maximum dimensions we can crop
                if ($src_width > $src_height){
                    $optimalWidth = $src_height;
                    $optimalHeight = $src_height;
                } else {
                    $optimalWidth = $src_width;
                    $optimalHeight = $src_width;
                }

                // Now, we know the optimal dimensions, we need to crop the image first then we will resize it

                // Create an empty image with optimal dimensions and also create an image from original image file
                $dst_image = imagecreatetruecolor($optimalWidth, $optimalHeight);
                imagealphablending($dst_image, false);
                imagesavealpha($dst_image, true);

                // We are creating a new image from base image to crop. You may ask "Why aren't you just using the base image rather
                // than creating a new one?".. Well my friend, if I use base image, crop will result with a solid black image.. If you
                // wondering why, then go ahead and google it! I'm sure you will find the answer, you are a smart guy! :)
                $src_image = ImageManager::create($type, $destFiles['base']);

                // Find the x,y coordinate of the cropping (top left coordinate of the crop start)
                $src_x = ($src_width / 2) - ($optimalWidth / 2);
                $src_y = ($src_height / 2) - ($optimalHeight / 2);

                // Crop it!
                $crop = imagecopyresampled($dst_image, $src_image, 0, 0, $src_x, $src_y, $optimalWidth, $optimalHeight, $optimalWidth, $optimalWidth);

                // Create another empty image with width and height of 300px
                $dst_image_r = imagecreatetruecolor($sqr_wh, $sqr_wh);
                imagealphablending($dst_image_r, false);
                imagesavealpha($dst_image_r, true);

                // Lets resize it to make it 300px
                $resize = imagecopyresampled($dst_image_r, $dst_image, 0, 0, 0, 0, $sqr_wh, $sqr_wh, $optimalWidth, $optimalHeight);

                // Write it to a file
                if ($type == IMAGETYPE_PNG) {
                    $file_type = 'png';
                } else {
                    $file_type = 'jpg';
                }
                $smallsqrImage = ImageManager::write($file_type, $dst_image_r, $destFiles['smallsqr']);

                if (!$mediumImage || !$smallImage || !$smallsqrImage){
                    $file['error'] = Tools::displayError('An error occured while trying to create images, please check the upload directory (modules/wpblog/views/uploads/) and make sure it has proper read/write permission (0755)');
                    continue;
                }

                unlink($file['save_path']);
                unset($file['save_path']);

                $file['status']   = 'ok';
                $file['name']     = $wpBlogPostImage->id . '-' . $wpBlogPostImage->id_wpblog_posts . '-' . $filenameParts[0];
                $file['id']       = $wpBlogPostImage->id;
                $file['position'] = $wpBlogPostImage->position;
                $file['path']     = $image_dir;
            }

        }

        die(Tools::jsonEncode(array($image_uploader->getName() => $files)));

	}
    
    
    /* ------------------------------------------------------------- */
    /*  UPDATE IMAGE POSITION
    /* ------------------------------------------------------------- */
    public function ajaxProcessUpdateImagePosition()
    {
		$response = false;
		if ($json = Tools::getValue('json')){
			$response = true;
			$json = stripslashes($json);
			$images = Tools::jsonDecode($json, true);
			foreach ($images as $id => $position){
				$wpBlogPostImage = new wpBlogPostImages((int)$id);
				$wpBlogPostImage->position = (int)$position;
				$response &= $wpBlogPostImage->update();
			}
		}
		if ($response) {
            $this->jsonConfirmation($this->_conf[25]);
        } else {
			$this->jsonError(Tools::displayError('An error occurred while attempting to move this picture.'));
        }
	}
    
    
    /* ------------------------------------------------------------- */
    /*  DELETE IMAGE
    /* ------------------------------------------------------------- */
    public function ajaxProcessDeletePostImage()
    {
		$response = true;
        
		// Delete image
		$wpBlogPostImage = new wpBlogPostImages((int)Tools::getValue('id_wpblog_post_images'));
		$response &= $wpBlogPostImage->delete();

		if ($response){
            die(Tools::jsonEncode(
                array(
                    'status' => 'ok',
                    'id' => $wpBlogPostImage->id_wpblog_post_images,
                    'confirmations' => array($this->l('The image was successfully deleted.'))
                )
            ));
        } else {
			$this->jsonError(Tools::displayError('An error occurred while attempting to delete the product image.'));
        }
	}

    /* ------------------------------------------------------------- */
    /*
    /*  BLOG POST RELATIONS
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  ADD RELATED PRODUCT
    /* ------------------------------------------------------------- */
    public function ajaxProcessAddPostRelatedProduct()
    {
        $id_wpblog_posts = Tools::getValue('id_wpblog_posts');
        $id_related_product = Tools::getValue('id_related_product');

        if ($id_wpblog_posts && $id_related_product)
        {
            // First check if the product exists
            if (!WPBlogPostRelationModel::isRelationExist($id_wpblog_posts, $id_related_product, 1)){
                $wpBlogPostRelation = new WPBlogPostRelationModel();
                $wpBlogPostRelation->id_wpblog_posts = $id_wpblog_posts;
                $wpBlogPostRelation->relation_type = 1; //Product
                $wpBlogPostRelation->id_related_object = $id_related_product;

                $response = $wpBlogPostRelation->add();
            } else {
                $error = Tools::displayError('This product already exists!');
                $response = false;
            }

        } else {
            $error = Tools::displayError('An error occurred while adding related product!');
            $response = false;
        }

        if ($response){
            $this->jsonConfirmation($this->l('Related product successfully added.'));
        } else {
            $this->jsonError($error);
        }
    }


    /* ------------------------------------------------------------- */
    /*  DELETE RELATED PRODUCT
    /* ------------------------------------------------------------- */
    public function ajaxProcessDeletePostRelatedProduct()
    {
        $id_wpblog_posts = Tools::getValue('id_wpblog_posts');
        $id_related_product = Tools::getValue('id_related_product');

        if ($id_wpblog_posts && $id_related_product)
        {
            $id_wpblog_post_relation = WPBlogPostRelationModel::getRelatedObjectID($id_wpblog_posts, $id_related_product, 1);

            if ($id_wpblog_post_relation) {
                $wpBlogPostRelation = new WPBlogPostRelationModel($id_wpblog_post_relation);
                $response = $wpBlogPostRelation->delete();
            } else {
                $error = Tools::displayError('An error occurred while removing related product from database!');
            }

        } else {
            $error = Tools::displayError('An error occurred while trying to remove related product!');
            $response = false;
        }

        if ($response){
            $this->jsonConfirmation($this->l('Related product successfully removed.'));
        } else {
            $this->jsonError($error);
        }
    }

}
