/**
* Module Prestashop PrettySlider
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

function changeTab(name) {
	$('#tab_'+id_tab).removeClass('active');
	$('#tab_'+name).addClass('active');
	$('#content_'+id_tab).css('display', 'none');
	$('#content_'+name).css('display', 'block');
	id_tab = name;
	editAreaLoader.init({
		id: "contentCSS",
		syntax: "css",
		start_highlight: true,
		allow_resize: "no",
		allow_toggle: false,
		toolbar: "search, |, go_to_line, |, highlight"
	});
}

$(document).ready(function() {
	$.each($('.colorpickerSelect'),function() {
		var $target = $(this);
		$(this).find('.colorpickerInput').ColorPicker({
			onSubmit: function(hsb, hex, rgb, el) {
				$(el).val(hex);
				$(el).ColorPickerHide();
			},
			onBeforeShow: function() {
				$(this).ColorPickerSetColor(this.value);
			},
			onChange: function(hsb, hex, rgb) {
				$target.find('.colorpickerPreview').css('backgroundColor', '#' + hex);
			}
		})
		.bind('keyup', function() {
			$(this).ColorPickerSetColor(this.value);
		});
	});
});

function nl2br(str, is_xhtml) {
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function loadFile(fileId) {
	getE('fileId').value = fileId;
	for (var i=0; i<=50; i++) {
		var fileName = getE('fileName_' + fileId).value;
	}
    var xhr;

	if (window.XMLHttpRequest) {
		xhr = new XMLHttpRequest();
	}
	else if (window.ActiveXObject) {
		try {
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {}
		}
	}
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			var new_file= {id: fileId, text: xhr.responseText, syntax: 'css', title: fileName};
			editAreaLoader.openFile('contentCSS', new_file);
			getE('fileName').value = fileName;
		} else if (xhr.readyState == 4 && xhr.status != 200) {
			alert('Une erreur est survenue !\n\nCode :' + xhr.status + '\nTexte : ' + xhr.statusText);
		}
	};
 
   xhr.open("GET", baseDir + fileName + '?nocache=' + Math.random(), true);
   xhr.send(null);
}

function slideEdit(slideId) {
	getE('id').value = slideId;
	var ls = parseInt(getE('languageNb').value - 1);
	for (var i=0; i<=ls; i++) {
		getE('titleInput_' + slides[slideId][i * 6]).value = slides[slideId][i * 6 + 1];
		getE('subtitleInput_' + slides[slideId][i * 6]).value = slides[slideId][i * 6 + 2];
		getE('linkInput_' + slides[slideId][i * 6]).value = slides[slideId][i * 6 + 3];
		getE('positionInput_' + slides[slideId][i * 6]).value = slides[slideId][i * 6 + 4];
		getE('activeInput_' + slides[slideId][i * 6]).value = slides[slideId][i * 6 + 5];
	}

	if (document.all) {
		getE('submitAddSlide').style.setAttribute('cssText', 'display:none');
		getE('submitEditSlide').style.setAttribute('cssText', '');
	}
	getE('submitAddSlide').setAttribute('style', 'display:none');
	getE('submitEditSlide').setAttribute('style', '');

	id_shop = $('#ps_id_shop').val();
    var url = '../modules/prettyslider/views/img/front/slide_img_' + slideId + '_' + id_shop + '.png';
    getE('slide_image').setAttribute('src', url);
	
	if (document.all) {
		getE('slide_image').style.setAttribute('cssText', 'display:block');
	}
	getE('slide_image').setAttribute('style', 'display:block');
}

function slideDelete(slideId) {
	document.location.replace(currentUrl+'&id='+slideId+'&token='+token);
}