/**
* Module Prestashop PrestacreaThemeManager
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

function changeTab(name) {
	$('#tab_'+id_tab).removeClass('active');
	$('#tab_'+name).addClass('active');
	$('#content_'+id_tab).css('display', 'none');
	$('#content_'+name).css('display', 'block');
	id_tab = name;
	editAreaLoader.init({
		id: "contentCSS",
		syntax: "css",
		start_highlight: true,
		allow_resize: "no",
		allow_toggle: false,
		toolbar: "search, |, go_to_line, |, highlight"
	});
}

$(document).ready(function() {
	$.each($('.colorpickerSelect'),function() {
		var $target = $(this);
		$(this).find('.colorpickerInput').ColorPicker({
			onSubmit: function(hsb, hex, rgb, el) {
				$(el).val(hex);
				$(el).ColorPickerHide();
			},
			onBeforeShow: function() {
				$(this).ColorPickerSetColor(this.value);
			},
			onChange: function(hsb, hex, rgb) {
				$target.find('.colorpickerPreview').css('backgroundColor', '#' + hex);
			}
		})
		.bind('keyup', function() {
			$(this).ColorPickerSetColor(this.value);
		});
	});
});

function nl2br(str, is_xhtml) {
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function loadFile(fileId) {
	getE('fileId').value = fileId;
	for (var i=0; i<=50; i++) {
		var fileName = getE('fileName_' + fileId).value;
	}
    var xhr;

	if (window.XMLHttpRequest) {
		xhr = new XMLHttpRequest();
	}
	else if (window.ActiveXObject) {
		try {
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {}
		}
	}
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			var new_file= {id: fileId, text: xhr.responseText, syntax: 'css', title: fileName};
			editAreaLoader.openFile('contentCSS', new_file);
			getE('fileName').value = fileName;
		} else if (xhr.readyState == 4 && xhr.status != 200) {
			alert('Une erreur est survenue !\n\nCode :' + xhr.status + '\nTexte : ' + xhr.statusText);
		}
	};
 
   xhr.open("GET", baseDir + fileName + '?nocache=' + Math.random(), true);
   xhr.send(null);
}

function fontPreview() {
	var select = document.getElementById("ptm_googlefont" );
	var valeur = select.options[select.selectedIndex].value;
	var text = select.options[select.selectedIndex].text;
	document.getElementById('googleFontLink').href = 'http://fonts.googleapis.com/css?family=' + valeur;
	document.getElementById('googleFontPreview').style.fontFamily = text;
	document.getElementById('googleFontPreview').innerHTML = text;
}