<?php
/* Copyright (C) 2003-2008	Rodolphe Quiedeville	<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2011	Laurent Destailleur		<eldy@users.sourceforge.net>
 * Copyright (C) 2004		Sebastien Di Cintio		<sdicintio@ressource-toi.org>
 * Copyright (C) 2004		Benoit Mortier			<benoit.mortier@opensides.be>
 * Copyright (C) 2004		Eric Seigne				<eric.seigne@ryxeo.com>
 * Copyright (C) 2005-2012	Regis Houssin			<regis.houssin@inodbox.com>
 * Copyright (C) 2011-2012	Juanjo Menent			<jmenent@2byte.es>
 * Copyright (C) 2011-2018	Philippe Grand			<philippe.grand@atoo-net.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/admin/expedition.php
 *	\ingroup    expedition
 *	\brief      Page d'administration/configuration du module Expedition
 */

require '../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

// Load translation files required by the page
$langs->loadLangs(array('admin', 'exports', 'other'));

if (! $user->admin)
	accessforbidden();

$action=GETPOST('action', 'alpha');
$value=GETPOST('value', 'alpha');

/*
 * Actions
 */

include DOL_DOCUMENT_ROOT.'/core/actions_setmoduleoptions.inc.php';


/*
 * View
 */

$form=new Form($db);

$page_name = "ExportSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">' . $langs->trans("BackToModuleList") . '</a>';

print load_fiche_titre($langs->trans($page_name), $linkback);

//$head = export_admin_prepare_head();
$h=0;
$head = array();
$head[$h][0] = DOL_URL_ROOT.'/admin/export.php';
$head[$h][1] = $langs->trans("Setup");
$head[$h][2] = 'setup';
$h++;

dol_fiche_head($head, 'setup', $langs->trans("ExportsArea"), -1, "exports");


print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("Parameters").'</td>'."\n";
print '<td class="center" width="20">&nbsp;</td>';
print '<td class="center" width="100"></td>'."\n";


// Example with a yes / no select
print '<tr class="oddeven">';
print '<td>'.$langs->trans("EXPORTS_SHARE_MODELS").'</td>';
print '<td class="center" width="20">&nbsp;</td>';
print '<td class="center" width="100">';

print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_EXPORTS_SHARE_MODELS">';
echo ajax_constantonoff('EXPORTS_SHARE_MODELS');
print '</form>';

print '</td></tr>';

print '</table>';

dol_fiche_end();

// End of page
llxFooter();
$db->close();
