{*
* Template Prestashop ** @author    VIRTUALDEV* @copyright VIRTUALDEV* @license   See PDF documentation* @website   http://www.virtualdev.tn
*}

{include file="$tpl_dir./errors.tpl"}
{if $errors|@count == 0}
<script type="text/javascript">
// <![CDATA[

// PrestaShop internal settings
var currencySign = '{$currencySign|html_entity_decode:2:"UTF-8"}';
var currencyRate = '{$currencyRate|floatval}';
var currencyFormat = '{$currencyFormat|intval}';
var currencyBlank = '{$currencyBlank|intval}';
var taxRate = {$tax_rate|floatval};
var jqZoomEnabled = {if $jqZoomEnabled}true{else}false{/if};

//JS Hook
var oosHookJsCodeFunctions = new Array();

// Parameters
var id_product = '{$product->id|intval}';
var productHasAttributes = {if isset($groups)}true{else}false{/if};
var quantitiesDisplayAllowed = {if $display_qties == 1}true{else}false{/if};
var quantityAvailable = {if $display_qties == 1 && $product->quantity}{$product->quantity}{else}0{/if};
var allowBuyWhenOutOfStock = {if $allow_oosp == 1}true{else}false{/if};
var availableNowValue = '{if $product->available_now}{$product->available_now|escape:'quotes':'UTF-8'}{else}{l s='Available' js=1}{/if}';
var availableLaterValue = '{if $product->available_later}{$product->available_later|escape:'quotes':'UTF-8'}{else}{l s='Preorder' js=1}{/if}';
var productPriceTaxExcluded = {$product->getPriceWithoutReduct(true)|default:'null'} - {$product->ecotax};
var reduction_percent = {if $product->specificPrice AND $product->specificPrice.reduction AND $product->specificPrice.reduction_type == 'percentage'}{$product->specificPrice.reduction*100}{else}0{/if};
var reduction_price = {if $product->specificPrice AND $product->specificPrice.reduction AND $product->specificPrice.reduction_type == 'amount'}{$product->specificPrice.reduction|floatval}{else}0{/if};
var specific_price = {if $product->specificPrice AND $product->specificPrice.price}{$product->specificPrice.price}{else}0{/if};
var product_specific_price = new Array();
{if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}
{foreach from=$product->specificPrice key='key_specific_price' item='specific_price_value'}
	product_specific_price['{$key_specific_price}'] = '{$specific_price_value}';
{/foreach}
{/if}
var specific_currency = {if $product->specificPrice AND $product->specificPrice.id_currency}true{else}false{/if};
{if version_compare($smarty.const._PS_VERSION_,'1.6.0.6','>=')}
	var group_reduction = '{1 - $group_reduction}';
{else}
	var group_reduction = '{$group_reduction}';
{/if}
var default_eco_tax = {$product->ecotax};
var ecotaxTax_rate = {$ecotaxTax_rate};
var currentDate = '{$smarty.now|date_format:'%Y-%m-%d %H:%M:%S'}';
var maxQuantityToAllowDisplayOfLastQuantityMessage = {$last_qties};
var noTaxForThisProduct = {if $no_tax == 1}true{else}false{/if};
var displayPrice = {$priceDisplay};
var productReference = '{$product->reference|escape:'html':'UTF-8'}';
var productAvailableForOrder = {if $PS_CATALOG_MODE}'0'{else}'{$product->available_for_order}'{/if};
var productShowPrice = '{if !$PS_CATALOG_MODE}{$product->show_price}{else}0{/if}';
var productUnitPriceRatio = '{$product->unit_price_ratio}';
var idDefaultImage = {if isset($cover.id_image_only)}{$cover.id_image_only}{else}0{/if};
{if isset($stock_management)}
var stock_management = {$stock_management|intval};
{/if}
{if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}
{if !isset($priceDisplayPrecision)}
	{assign var='priceDisplayPrecision' value=2}
{/if}
{if !$priceDisplay || $priceDisplay == 2}
	{assign var='productPrice' value=$product->getPrice(true, $smarty.const.NULL, $priceDisplayPrecision)}
	{assign var='productPriceWithoutReduction' value=$product->getPriceWithoutReduct(false, $smarty.const.NULL)}
{elseif $priceDisplay == 1}
	{assign var='productPrice' value=$product->getPrice(false, $smarty.const.NULL, $priceDisplayPrecision)}
	{assign var='productPriceWithoutReduction' value=$product->getPriceWithoutReduct(true, $smarty.const.NULL)}
{/if}
var productPrice = '{$productPrice}';
{/if}

// Customizable field
var img_ps_dir = '{$img_ps_dir}';
var customizationFields = new Array();
{assign var='imgIndex' value=0}
{assign var='textFieldIndex' value=0}
{foreach from=$customizationFields item='field' name='customizationFields'}
	{assign var="key" value="pictures_`$product->id`_`$field.id_customization_field`"}
	customizationFields[{$smarty.foreach.customizationFields.index|intval}] = new Array();
	customizationFields[{$smarty.foreach.customizationFields.index|intval}][0] = '{if $field.type|intval == 0}img{$imgIndex++}{else}textField{$textFieldIndex++}{/if}';
	customizationFields[{$smarty.foreach.customizationFields.index|intval}][1] = {if $field.type|intval == 0 && isset($pictures.$key) && $pictures.$key}2{else}{$field.required|intval}{/if};
{/foreach}

// Images
var img_prod_dir = '{$img_prod_dir}';
var combinationImages = new Array();

{if isset($combinationImages)}
	{foreach from=$combinationImages item='combination' key='combinationId' name='f_combinationImages'}
		combinationImages[{$combinationId}] = new Array();
		{foreach from=$combination item='image' name='f_combinationImage'}
			combinationImages[{$combinationId}][{$smarty.foreach.f_combinationImage.index}] = {$image.id_image|intval};
		{/foreach}
	{/foreach}
{/if}

combinationImages[0] = new Array();
{if isset($images)}
	{foreach from=$images item='image' name='f_defaultImages'}
		combinationImages[0][{$smarty.foreach.f_defaultImages.index}] = {$image.id_image};
	{/foreach}
{/if}

// Translations
var doesntExist = '{l s='This combination does not exist for this product. Please choose another.' js=1}';
var doesntExistNoMore = '{l s='This product is no longer in stock' js=1}';
var doesntExistNoMoreBut = '{l s='with those attributes but is available with others' js=1}';
var uploading_in_progress = '{l s='Uploading in progress, please wait...' js=1}';
var fieldRequired = '{l s='Please fill in all required fields, then save the customization.' js=1}';
{if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}
{if isset($groups)}
	// Combinations
	{foreach from=$combinations key=idCombination item=combination}
		var specific_price_combination = new Array();
		specific_price_combination['reduction_percent'] = {if $combination.specific_price AND $combination.specific_price.reduction AND $combination.specific_price.reduction_type == 'percentage'}{$combination.specific_price.reduction*100}{else}0{/if};
		specific_price_combination['reduction_price'] = {if $combination.specific_price AND $combination.specific_price.reduction AND $combination.specific_price.reduction_type == 'amount'}{$combination.specific_price.reduction}{else}0{/if};
		specific_price_combination['price'] = {if $combination.specific_price AND $combination.specific_price.price}{$combination.specific_price.price}{else}0{/if};
		specific_price_combination['reduction_type'] = '{if $combination.specific_price}{$combination.specific_price.reduction_type}{/if}';
		addCombination({$idCombination|intval}, new Array({$combination.list}), {$combination.quantity}, {$combination.price}, {$combination.ecotax}, {$combination.id_image}, '{$combination.reference|addslashes}', {$combination.unit_impact}, {$combination.minimal_quantity}, '{$combination.available_date}', '{if isset($combination.date_formatted)}{$combination.date_formatted}{/if}', specific_price_combination);
	{/foreach}
{/if}

{if isset($attributesCombinations)}
	// Combinations attributes informations
	var attributesCombinations = new Array();
	{foreach from=$attributesCombinations key=id item=aC}
		tabInfos = new Array();
		tabInfos['id_attribute'] = '{$aC.id_attribute|intval}';
		tabInfos['attribute'] = '{$aC.attribute}';
		tabInfos['group'] = '{$aC.group}';
		tabInfos['id_attribute_group'] = '{$aC.id_attribute_group|intval}';
		attributesCombinations.push(tabInfos);
	{/foreach}
{/if}
{else}
{if isset($groups)}
	// Combinations
	{foreach from=$combinations key=idCombination item=combination}
		addCombination({$idCombination|intval}, new Array({$combination.list}), {$combination.quantity}, {$combination.price}, {$combination.ecotax}, {$combination.id_image}, '{$combination.reference|addslashes}', {$combination.unit_impact}, {$combination.minimal_quantity});
	{/foreach}
	// Colors
	{if $colors|@count > 0}
		{if $product->id_color_default}var id_color_default = {$product->id_color_default|intval};{/if}
	{/if}
{/if}
{/if}
//]]>
</script>

{if !$content_only}
	{include file="$tpl_dir./breadcrumb.tpl"}
{/if}
<div itemscope itemtype="http://schema.org/Product">
<h1 itemprop="name">{$product->name|escape:'html':'UTF-8'}</h1>

	{if isset($adminActionDisplay) && $adminActionDisplay}
	<div id="admin-action">
		<p>{l s='This product is not visible to your customers.'}
		<input type="hidden" id="admin-action-product-id" value="{$product->id}" />
		<input type="submit" value="{l s='Publish'}" class="exclusive" onclick="submitPublishProduct('{$base_dir}{$smarty.get.ad|escape:'html':'UTF-8'}', 0, '{$smarty.get.adtoken|escape:'html':'UTF-8'}')"/>
		<input type="submit" value="{l s='Back'}" class="exclusive" onclick="submitPublishProduct('{$base_dir}{$smarty.get.ad|escape:'html':'UTF-8'}', 1, '{$smarty.get.adtoken|escape:'html':'UTF-8'}')"/>
		</p>
		<p id="admin-action-result"></p>
		</p>
	</div>
	{/if}

	{if isset($confirmation) && $confirmation}
	<p class="confirmation">
		{$confirmation}
	</p>
	{/if}
	
<div id="primary_block"  >

	<!-- right infos-->
	<div id="pb-right-column">
		
		{if !$priceDisplay || $priceDisplay == 2}
			{assign var='productPrice' value=$product->getPrice(true, $smarty.const.NULL, $priceDisplayPrecision)}
			{assign var='productPriceWithoutRedution' value=$product->getPriceWithoutReduct(false, $smarty.const.NULL)}
		{elseif $priceDisplay == 1}
			{assign var='productPrice' value=$product->getPrice(false, $smarty.const.NULL, $priceDisplayPrecision)}
			{assign var='productPriceWithoutRedution' value=$product->getPriceWithoutReduct(true, $smarty.const.NULL)}
		{/if}

		<div class="reduction_img_container{if !$product->specificPrice.reduction} hidden{/if}">
			<p class="reduction_img">{if $product->on_sale}{l s='On sale'}{else}{l s='Promotion'}{/if}</p>
		</div>
		
		<!-- product img-->
		<div id="image-block">
		{if $have_image}
			<span id="view_full_size">
				{if version_compare($smarty.const._PS_VERSION_,'1.6','>=') AND $jqZoomEnabled}<a class="jqzoom" title="{if !empty($cover.legend)}{$cover.legend|escape:'html':'UTF-8'}{else}{$product->name|escape:'html':'UTF-8'}{/if}" rel="child" href="{$link->getImageLink($product->link_rewrite, $cover.id_image, 'thickbox')|escape:'html':'UTF-8'}">{/if}
					<img src="{$link->getImageLink($product->link_rewrite, $cover.id_image, 'large')}" {if $jqZoomEnabled}class="jqzoom" alt="{$link->getImageLink($product->link_rewrite, $cover.id_image, 'thickbox')}"{else} title="{$product->name|escape:'html':'UTF-8'}" alt="{$product->name|escape:'html':'UTF-8'}" {/if} id="bigpic" />
				{if version_compare($smarty.const._PS_VERSION_,'1.6','>=') AND $jqZoomEnabled}</a>{/if}
			</span>
		{else}
			<span id="view_full_size">
				<img src="{$img_prod_dir}{$lang_iso}-default-large.jpg" id="bigpic" alt="" title="{$product->name|escape:'html':'UTF-8'}" />
			</span>
		{/if}
		</div>
		
		{if !$content_only}
			<!-- usefull links-->
			<ul id="usefull_link_block">
				{if isset($HOOK_EXTRA_LEFT) && $HOOK_EXTRA_LEFT}{$HOOK_EXTRA_LEFT}{/if}
			</ul>
		{/if}
		
		{if isset($HOOK_EXTRA_RIGHT) && $HOOK_EXTRA_RIGHT}{$HOOK_EXTRA_RIGHT}{/if}
		
	</div>

	<!-- left infos-->
	<div id="pb-left-column">

		{if $product->description_short OR $packItems|@count > 0}
		<div id="short_description_block">
			{if $product->online_only OR isset($product->is_virtual) && !$product->is_virtual && $product->condition && $product->condition != 'new'}
				<p class="online_only">
					{if $product->online_only}{l s='Online only'}{if $product->condition != 'new'} - {/if}{/if}
					{if $product->condition == 'new'}{elseif $product->condition == 'used'}{l s='Used product'}{elseif $product->condition == 'refurbished'}{l s='Refurbished product'}{/if}
				</p>
			{/if}
			{if $product->description_short}
				<div itemprop="description" id="short_description_content" class="rte align_justify">{$product->description_short}</div>
			{/if}
			{if $product->description AND !$content_only}
				<p class="buttons_bottom_block"><a href="javascript:{ldelim}{rdelim}" class="lnk">{l s='More details...'}</a></p>
			{/if}
			{if $packItems|@count > 0 AND !$content_only}
			<div class="short_description_pack">
				<h3>{l s='Pack content'}</h3>
				{foreach from=$packItems item=packItem}
				<div class="pack_content">
					{$packItem.pack_quantity} x <a href="{$link->getProductLink($packItem.id_product, $packItem.link_rewrite, $packItem.category)}">{$packItem.name|escape:'html':'UTF-8'}</a>
				</div>
				{/foreach}
			</div>
			{/if}
		</div>
		{/if}
		
		{if isset($images) && count($images) > 0}
		<!-- thumbnails -->
		<div id="views_block" class="{if isset($images) && count($images) < 2}hidden{/if}">
			<div id="thumbs_list">
				<ul id="thumbs_list_frame">
					{if isset($images)}
						{foreach from=$images item=image name=thumbnails}
							{assign var=imageIds value="`$product->id`-`$image.id_image`"}
							<li id="thumbnail_{$image.id_image}" {if $smarty.foreach.thumbnails.first}class="first"{/if}>
								<a href="{$link->getImageLink($product->link_rewrite, $imageIds, thickbox)}" {if version_compare($smarty.const._PS_VERSION_,'1.6','>=') AND $jqZoomEnabled}href="javascript:void(0);"{/if} {if version_compare($smarty.const._PS_VERSION_,'1.6','>=') AND $jqZoomEnabled}rel="{literal}{{/literal}gallery: 'child', smallimage: '{$link->getImageLink($product->link_rewrite, $imageIds, 'large')|escape:'html':'UTF-8'}',largeimage: '{$link->getImageLink($product->link_rewrite, $imageIds, 'thickbox')|escape:'html':'UTF-8'}'{literal}}{/literal}"{else}data-fancybox-group="other-views"{/if} class="thickbox{if $smarty.foreach.thumbnails.first} shown{/if}" title="{$image.legend|htmlspecialchars}" rel="child">
									<img class="replace-2x" {if $smarty.foreach.thumbnails.first}itemprop="image"{/if} id="thumb_{$image.id_image}" src="{$link->getImageLink($product->link_rewrite, $imageIds, 'medium')}" alt="{$image.legend|htmlspecialchars}" {if isset($imgMediumSize)}style="height:{$imgMediumSize.height}px;width:{$imgMediumSize.width}px"{/if} />
								</a>
							</li>
						{/foreach}
					{/if}
				</ul>
			</div>
			<div class="clear"></div>
			{if isset($images) && count($images) > 1}
				<a id="views_block_prev" href="#">&lsaquo;</a>
				<a id="views_block_next" href="#">&rsaquo;</a>
			{/if}
		</div>
		{/if}
		{if isset($images) && count($images) > 1}<p class="resetimg"><span id="wrapResetImages" style="display:none"><a id="resetImages" href="{$link->getProductLink($product)}" onclick="$('span#wrapResetImages').hide('slow');return(false);">{l s='Display all pictures'}</a></span></p>{/if}

		{if $product->show_price OR isset($groups) OR $product->reference OR (isset($HOOK_PRODUCT_ACTIONS) && $HOOK_PRODUCT_ACTIONS)}
		<div itemprop="offers" itemscope itemtype="http://schema.org/Offer">
		<!-- add to cart form-->
		<form id="buy_block" {if $PS_CATALOG_MODE AND !isset($groups) AND $product->quantity > 0}class="hidden"{/if} action="{$link->getPageLink('cart.php')}" method="post">

			<!-- hidden datas -->
			<p class="hidden">
				<input type="hidden" name="token" value="{$static_token}" />
				<input type="hidden" name="id_product" value="{$product->id|intval}" id="product_page_product_id" />
				<input type="hidden" name="add" value="1" />
				<input type="hidden" name="id_product_attribute" id="idCombination" value="" />
			</p>

			<div class="product_attributes">
				{if isset($groups)}
				<!-- attributes -->
				<div id="attributes">
				{foreach from=$groups key=id_attribute_group item=group}
					{if $group.attributes|@count}
						<fieldset class="attribute_fieldset">
							<label class="attribute_label" for="group_{$id_attribute_group|intval}">{$group.name|escape:'html':'UTF-8'} :</label>
							{assign var="groupName" value="group_$id_attribute_group"}
							<div class="attribute_list">
							{if (isset($group.group_type) && $group.group_type == 'select')}
								<select name="{$groupName}" id="group_{$id_attribute_group|intval}" class="attribute_select" onchange="findCombination();getProductAttribute();{if $colors|@count > 0}$('#wrapResetImages').show('slow');{/if};">
									{foreach from=$group.attributes key=id_attribute item=group_attribute}
										<option value="{$id_attribute|intval}"{if (isset($smarty.get.$groupName) && $smarty.get.$groupName|intval == $id_attribute) || $group.default == $id_attribute} selected="selected"{/if} title="{$group_attribute|escape:'html':'UTF-8'}">{$group_attribute|escape:'html':'UTF-8'}</option>
									{/foreach}
								</select>
							{elseif (isset($group.group_type) && $group.group_type == 'color')}
								<ul id="color_to_pick_list">
									{assign var="default_colorpicker" value=""}
									{foreach from=$group.attributes key=id_attribute item=group_attribute}
									<li{if $group.default == $id_attribute} class="selected"{/if}>
										<a id="color_{$id_attribute|intval}" class="color_pick{if ($group.default == $id_attribute)} selected{/if}" style="background:{$colors.$id_attribute.value}" title="{$colors.$id_attribute.name}" onclick="colorPickerClick(this);getProductAttribute();{if $colors|@count > 0}$('#wrapResetImages').show('slow');{/if}">
											{if file_exists($col_img_dir|cat:$id_attribute|cat:'.jpg')}
												<img src="{$img_col_dir}{$id_attribute}.jpg" alt="{$colors.$id_attribute.name}" /><br>
											{/if}
										</a>
									</li>
									{if ($group.default == $id_attribute)}
										{$default_colorpicker = $id_attribute}
									{/if}
									{/foreach}
								</ul>
								<input type="hidden" class="color_pick_hidden" name="{$groupName}" value="{$default_colorpicker}" />
							{elseif (isset($group.group_type) && $group.group_type == 'radio')}
								{foreach from=$group.attributes key=id_attribute item=group_attribute}
									<input type="radio" class="attribute_radio" name="{$groupName}" value="{$id_attribute}" {if ($group.default == $id_attribute)} checked="checked"{/if} onclick="this.blur()" onchange="findCombination();getProductAttribute();{if $colors|@count > 0}$('#wrapResetImages').show('slow');{/if}">
									{$group_attribute|escape:'html':'UTF-8'}<br/>
								{/foreach}
							{elseif !isset($group.group_type)}
							<select name="{$groupName}" id="group_{$id_attribute_group|intval}" onchange="javascript:findCombination();{if $colors|@count > 0}$('#wrapResetImages').show('slow');{/if};" {if $group.is_color_group AND $colors}style="display:none"{/if}>
								{foreach from=$group.attributes key=id_attribute item=group_attribute}
									<option value="{$id_attribute|intval}"{if (isset($smarty.get.$groupName) && $smarty.get.$groupName|intval == $id_attribute) || $group.default == $id_attribute} selected="selected"{/if} title="{$group_attribute|escape:'html':'UTF-8'}">{$group_attribute|escape:'html':'UTF-8'}</option>
								{/foreach}
							</select>
							
							{if $group.is_color_group}
								{if isset($colors) && $colors}
								<!-- colors -->
								<div id="color_picker">
									<ul id="color_to_pick_list">
										{foreach from=$colors key='id_attribute' item='color'}
											<li class="color_pick_li"><a id="color_{$id_attribute|intval}" class="color_pick" style="background:{$color.value}" onclick="updateColorSelect({$id_attribute|intval});$('#wrapResetImages').show('slow');" title="{$color.name}">{if file_exists($col_img_dir|cat:$id_attribute|cat:'.jpg')}<img src="{$img_col_dir}{$id_attribute}.jpg" alt="{$color.name}" />{/if}</a></li>
										{/foreach}
									</ul>
								</div>
								{/if}
							{/if}
							
							{/if}
							</div>
						</fieldset>
					{/if}
				{/foreach}
		
				</div>
				{/if}
				
				{if !$PS_CATALOG_MODE}
				<div class="content_prices">
					<!-- prices -->
					{if $product->show_price AND !$PS_CATALOG_MODE}

					<div itemprop="priceCurrency" content="TND" class="price">
						{if !$priceDisplay || $priceDisplay == 2}
							{assign var='productPrice' value=$product->getPrice(true, $smarty.const.NULL, $priceDisplayPrecision)}
							{assign var='productPriceWithoutRedution' value=$product->getPriceWithoutReduct(false, $smarty.const.NULL)}
						{elseif $priceDisplay == 1}
							{assign var='productPrice' value=$product->getPrice(false, $smarty.const.NULL, $priceDisplayPrecision)}
							{assign var='productPriceWithoutRedution' value=$product->getPriceWithoutReduct(true, $smarty.const.NULL)}
						{/if}
				
						<p class="reduction{if !$product->specificPrice.reduction} hidden{/if}">{if $product->on_sale}{l s='On sale'}{else}{l s='Promotion'}{/if} <span class="reduction_display">{if isset($product->specificPrice.reduction_type) && $product->specificPrice.reduction_type == 'percentage'}-{$product->specificPrice.reduction*100}%{/if}{if isset($product->specificPrice.reduction_type) && $product->specificPrice.reduction_type == 'amount'}-{convertPrice price=$product->specificPrice.reduction}{/if}</span></p>
				
						<p class="our_price_display">
							{if $priceDisplay >= 0 && $priceDisplay <= 2}
								<span itemprop="price" id="our_price_display" class="price">{convertPrice price=$productPrice}</span>
								<!--{if $tax_enabled  && ((isset($display_tax_label) && $display_tax_label == 1) OR !isset($display_tax_label))}
									{if $priceDisplay == 1}{l s='tax excl.'}{else}{l s='tax incl.'}{/if}
								{/if}-->
							{/if}
						</p>
				
						<p class="old_price_display{if !$product->specificPrice.reduction} hidden{/if}">
							{if $priceDisplay >= 0 && $priceDisplay <= 2}
								{l s='instead of'} <span id="old_price_display" class="old_price">{convertPrice price=$productPriceWithoutRedution}</span>
								<!-- {if $tax_enabled && $display_tax_label == 1}
									{if $priceDisplay == 1}{l s='tax excl.'}{else}{l s='tax incl.'}{/if}
								{/if} -->
							{/if}
						</p>

						{if $priceDisplay == 2}
							<br />
							<span id="pretaxe_price"><span id="pretaxe_price_display">{convertPrice price=$product->getPrice(false, $smarty.const.NULL)}</span>&nbsp;{l s='tax excl.'}</span>
						{/if}
					</div>
					{if $packItems|@count && $productPrice < $product->getNoPackPrice() AND !$content_only}
						<p class="pack_price"><span>{convertPrice price=$product->getNoPackPrice()}</span> {l s='excluding pack'}</p>
					{/if}
					{if $product->ecotax != 0}
						<p class="price-ecotax">{l s='include'} <span id="ecotax_price_display">{if $priceDisplay == 2}{$ecotax_tax_exc|convertAndFormatPrice}{else}{$ecotax_tax_inc|convertAndFormatPrice}{/if}</span> {l s='for green tax'}
							{if $product->specificPrice AND $product->specificPrice.reduction}
							<br />{l s='(not impacted by the discount)'}
							{/if}
						</p>
					{/if}
					{if !empty($product->unity) && $product->unit_price_ratio > 0.000000}
						{math equation="pprice / punit_price"  pprice=$productPrice  punit_price=$product->unit_price_ratio assign=unit_price}
						<p class="unit-price"><span id="unit_price_display">{convertPrice price=$unit_price}</span> {l s='per'} {$product->unity|escape:'html':'UTF-8'}</p>
					{/if}
					{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
						<div class="aeuc_block">
							{hook h="displayProductPriceBlock" product=$product type="price"}
						</div>
					{/if}
					{*close if for show price*}
					{/if}
					
					<p id="product_reference" {if isset($groups) OR !$product->reference}style="display:none"{/if}>
						<label>{l s='Reference :'} </label>
						<span class="editable">{$product->reference|escape:'html':'UTF-8'}</span>
					</p>

				</div>
				{/if}
				<div class="clear"></div>
			
				<!-- minimal quantity wanted -->
				{if !isset($restricted_country_mode)}
				<p id="minimal_quantity_wanted_p" {if $product->minimal_quantity <= 1 OR !$product->available_for_order OR $PS_CATALOG_MODE}style="display:none"{/if}>
					{l s='This product is not sold individually. You must select at least'} <b id="minimal_quantity_label">{$product->minimal_quantity}</b> {l s='quantity for this product.'}
				</p>
				{if $product->minimal_quantity > 1}
				<script type="text/javascript">
					checkMinimalQuantity();
				</script>
				{/if}
				{/if}

				<!-- availability -->
				{if $PS_STOCK_MANAGEMENT}
				<p id="availability_statut" {if !$product->available_for_order OR $PS_CATALOG_MODE}style="display:none"{/if}>
					<span id="availability_label">{l s='Availability :'}</span>
					<span id="availability_value" class="{if $product->quantity <= 0}{if $allow_oosp}available_later{else}outofstock{/if}{else}available{/if}">
						{if $product->quantity <= 0}{if $allow_oosp}{if isset($product->available_later) && $product->available_later}{$product->available_later}{else}{l s='Preorder'}{/if}{else}{l s='This product is no longer in stock'}{/if}{else}{if isset($product->available_now) && $product->available_now}{$product->available_now}{else}{l s='Available'}{/if}{/if}
					</span>
				</p>
				{if isset($product->available_date) && $product->available_date > $smarty.now|date_format:'%Y-%m-%d' && $product->available_for_order && !$PS_CATALOG_MODE}
					<p id="availability_date">
						<span id="availability_date_label">{l s='Availability date :'}</span>
						<span id="availability_date_value">{dateFormat date=$product->available_date full=false}</span>
					</p>
				{/if}
				
				{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
					<div class="aeuc_block">
						{hook h="displayProductPriceBlock" product=$product type="weight" hook_origin='product_sheet'}
                        {hook h="displayProductPriceBlock" product=$product type="after_price"}
					</div>
				{/if}
				<div class="clear"></div>

				<!-- number of item in stock -->
				{if ($display_qties == 1 && !$PS_CATALOG_MODE && $product->available_for_order)}
				<p id="pQuantityAvailable" {if $product->quantity <= 0}style="display:none"{/if}>
					<span id="quantityAvailable">{$product->quantity|intval}</span>
					<span id="quantityAvailableTxt" {if $product->quantity > 1}style="display:none"{/if}>{l s='item in stock'}</span>
					<span id="quantityAvailableTxtMultiple" {if $product->quantity == 1}style="display:none"{/if}>{l s='items in stock'}</span>
				</p>
				{/if}
			
				<p class="warning_inline" id="last_quantities" {if ($product->quantity > $last_qties OR $product->quantity <= 0) OR $allow_oosp OR !$product->available_for_order OR $PS_CATALOG_MODE}style="display:none"{/if}>{l s='Warning: Last items in stock !'}</p>
				{/if}
				
				{if !$product->available_for_order}
					<p class="unavailable">{l s='Unavailable product'}</p>
				{/if}
				<div class="clear"></div>
				
			</div>
			
			<div class="add_to_cart_block">
				{if !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
					{if (!$allow_oosp && $product->quantity <= 0) OR !$product->available_for_order OR $PS_CATALOG_MODE}
						{*<p id="add_to_cart" class="buttons_bottom_block">
							<span class="exclusive">{l s='Add to cart'}</span>
						</p>*}
					{else}
						<p id="add_to_cart" class="buttons_bottom_block">
							<input type="submit" name="Submit" value="{l s='Add to cart'}" class="exclusive" />
						</p>
					{/if}
				{/if}
				<!-- quantity wanted -->
				{if !isset($restricted_country_mode)}
				<p id="quantity_wanted_p" {if (!$allow_oosp && $product->quantity <= 0) OR $virtual OR !$product->available_for_order OR $PS_CATALOG_MODE}style="display:none"{/if}>
					<label>{l s='Quantity :'}</label>
					<input type="text" name="qty" id="quantity_wanted" class="text" value="{if isset($quantityBackup)}{$quantityBackup|intval}{else}{if $product->minimal_quantity > 1}{$product->minimal_quantity}{else}1{/if}{/if}" size="2" maxlength="3" {if $product->minimal_quantity > 1}onkeyup="checkMinimalQuantity({$product->minimal_quantity});"{/if} />
				</p>
				{/if}
				{if isset($HOOK_PRODUCT_ACTIONS) && $HOOK_PRODUCT_ACTIONS}{$HOOK_PRODUCT_ACTIONS}{/if}
				<div class="clear"></div>
			</div>
			
			<!-- Out of stock hook -->
			<div id="oosHook" {if $product->quantity > 0}style="display:none"{/if}>
				{$HOOK_PRODUCT_OOS}
			</div>
			
		</form>
		</div>
		{/if}
	</div>
	<div class="clear"></div>
</div>

{if !$content_only}

{if (isset($quantity_discounts) && count($quantity_discounts) > 0)}
<div id="quantity_discount">
<!-- quantity discount -->
<ul class="idTabs clearfix">
	<li><a href="#discount" class="selected">{l s='Quantity discount'}</a></li>
</ul>
<div id="quantityDiscount" class="sheets">
	<table class="std">
        <thead>
            <tr>
                {if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}<th>{l s='Product'}</th>{/if}
                <th>{l s='From (qty)'}</th>
                <th>{if Configuration::get('PS_DISPLAY_DISCOUNT_PRICE')}{l s='Price'}{else}{l s='Discount'}{/if}</th>
            </tr>
        </thead>
		<tbody>
            {foreach from=$quantity_discounts item='quantity_discount' name='quantity_discounts'}
            <tr {if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}id="quantityDiscount_{$quantity_discount.id_product_attribute}" data-discount-type="{$quantity_discount.reduction_type}" data-discount="{$quantity_discount.real_value|floatval}"{/if}>
                {if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}
					<td>
						{if (isset($quantity_discount.attributes) && ($quantity_discount.attributes))}
							{$product->getProductName($quantity_discount.id_product, $quantity_discount.id_product_attribute)}
						{else}
							{$product->getProductName($quantity_discount.id_product)}
						{/if}
					</td>
				{/if}
                <td>{$quantity_discount.quantity|intval}</td>
                <td>
					{if isset($quantity_discount.reduction_type) && $quantity_discount.reduction_type == 'amount'}
						{if $quantity_discount.price >= 0 OR Configuration::get('PS_DISPLAY_DISCOUNT_PRICE')}
							{convertPrice price=$productPriceWithoutReduction-$quantity_discount.real_value|floatval}
						{else}
							-{convertPrice price=$quantity_discount.real_value|floatval}
						{/if}
					{else}
						{if Configuration::get('PS_DISPLAY_DISCOUNT_PRICE')}
							{convertPrice price = $productPriceWithoutReduction-($productPriceWithoutReduction*$quantity_discount.reduction)|floatval}
						{else}
							-{$quantity_discount.real_value|floatval}%
						{/if}
                   {/if}
                </td>
            </tr>
            {/foreach}
        </tbody>
	</table>
</div>
</div>
{/if}

<!-- description and features -->
{if (isset($product) && $product->description) || (isset($features) && $features) || (isset($attachments) && $attachments) || isset($product) && $product->customizable}
<div id="more_info_block" {if isset($accessories) AND $accessories}style="float:left;width:56%"{/if}>
	<ul id="more_info_tabs" class="idTabs idTabsShort clearfix">
		{if $product->description}<li><a id="more_info_tab_more_info" href="#idTab1">{l s='More info'}</a></li>{/if}
		{if $features}<li><a id="more_info_tab_data_sheet" href="#idTab2">{l s='Data sheet'}</a></li>{/if}
		{if $attachments}<li><a id="more_info_tab_attachments" href="#idTab9">{l s='Download'}</a></li>{/if}
		{if isset($product) && $product->customizable}<li><a href="#idTab10">{l s='Product customization'}</a></li>{/if}
	</ul>
	<div id="more_info_sheets" class="sheets align_justify">
	{if isset($product) && $product->description}
		<!-- full description -->
		<div id="idTab1" class="rte">{$product->description}</div>
	{/if}
	{if isset($features) && $features}
		<!-- product's features -->
		<ul id="idTab2" class="bullet">
		{foreach from=$features item=feature}
            {if isset($feature.value)}
			    <li><span>{$feature.name|escape:'html':'UTF-8'}</span> {$feature.value|escape:'html':'UTF-8'}</li>
            {/if}
		{/foreach}
		</ul>
	{/if}
	{if isset($attachments) && $attachments}
		<ul id="idTab9" class="bullet">
		{foreach from=$attachments item=attachment}
			<li><a href="{$link->getPageLink('attachment.php', true)}?id_attachment={$attachment.id_attachment}">{$attachment.name|escape:'html':'UTF-8'}</a><br />{$attachment.description|escape:'html':'UTF-8'}</li>
		{/foreach}
		</ul>
	{/if}

	<!-- Customizable products -->
	{if isset($product) && $product->customizable}
		<div id="idTab10" class="customization_block">
			<form method="post" action="{$customizationFormTarget}" enctype="multipart/form-data" id="customizationForm" class="std clearfix">
				<p class="infoCustomizable">
					{l s='After saving your customized product, remember to add it to your cart.'}
					{if $product->uploadable_files}<br />{l s='Allowed file formats are: GIF, JPG, PNG'}{/if}
				</p>
				{if $product->uploadable_files|intval}
				<div class="customizableProductsFile">
					<h3>{l s='Pictures'}</h3>
					<ul id="uploadable_files" class="clearfix">
						{counter start=0 assign='customizationField'}
						{foreach from=$customizationFields item='field' name='customizationFields'}
							{if $field.type == 0}
								<li class="customizationUploadLine{if $field.required} required{/if}">{assign var='key' value='pictures_'|cat:$product->id|cat:'_'|cat:$field.id_customization_field}
									{if isset($pictures.$key)}
									<div class="customizationUploadBrowse">
										<img src="{$pic_dir}{$pictures.$key}_small" alt="" />
										<a href="{$link->getProductDeletePictureLink($product, $field.id_customization_field)}" title="{l s='Delete'}" >
											<i class="icon-cross customization_delete_icon"></i>
										</a>
									</div>
									{/if}
									<div class="customizationUploadBrowse">
										<label class="customizationUploadBrowseDescription">{if !empty($field.name)}{$field.name}{else}{l s='Please select an image file from your hard drive.'}{/if}{if $field.required}<sup>*</sup>{/if}</label>
										<input type="file" name="file{$field.id_customization_field}" id="img{$customizationField}" class="customization_block_input{if isset($pictures.$key)} filled{/if}" />
									</div>
								</li>
								{counter}
							{/if}
						{/foreach}
					</ul>
				</div>
				{/if}
				{if $product->text_fields|intval}
				<div class="customizableProductsText">
					<h3>{l s='Texts'}</h3>
					<ul id="text_fields">
					{counter start=0 assign='customizationField'}
					{foreach from=$customizationFields item='field' name='customizationFields'}
						{if $field.type == 1}
						<li class="customizationUploadLine{if $field.required} required{/if}">
							<label for ="textField{$customizationField}">{assign var='key' value='textFields_'|cat:$product->id|cat:'_'|cat:$field.id_customization_field} {if !empty($field.name)}{$field.name}{/if}{if $field.required}<sup>*</sup>{/if}</label>
							<textarea name="textField{$field.id_customization_field}" id="textField{$customizationField}" rows="2" cols="40" class="customization_block_input">{if isset($textFields.$key)}{$textFields.$key|stripslashes}{/if}</textarea>
						</li>
						{counter}
						{/if}
					{/foreach}
					</ul>
				</div>
				{/if}
				<p id="customizedDatas">
					<input type="hidden" name="quantityBackup" id="quantityBackup" value="" />
					<input type="hidden" name="submitCustomizedDatas" value="1" />
					<input type="button" class="button" value="{l s='Save'}" onclick="javascript:saveCustomization()" />
					<span id="ajax-loader" style="display:none"><img src="{$img_ps_dir}loader.gif" alt="loader" /></span>
				</p>
			</form>
			<p class="required"><sup>*</sup>{l s='Required fields'}</p>
		</div>
	{/if}

	</div>
</div>
{/if}

{if isset($accessories) AND $accessories}
	<div id="accessories_block">
		<ul class="idTabs idTabsShort">
			<li><a href="#idTab4">{l s='Accessories'}</a></li>
		</ul>
		<!-- accessories -->
		<ul id="idTab4" class="sheets"><li>
			<div class="products_block accessories_block">
				<ul class="clearfix">
				{foreach from=$accessories item=accessory name=accessories_list}
					{assign var='accessoryLink' value=$link->getProductLink($accessory.id_product, $accessory.link_rewrite, $accessory.category)}
					<li class="ajax_block_product {if $smarty.foreach.accessories_list.first}first_item{elseif $smarty.foreach.accessories_list.last}last_item{else}item{/if} product_accessories_description">
						{assign var='specific_prices' value=$accessory.specific_prices}
						<a href="{$accessoryLink|escape:'html':'UTF-8'}" title="{$accessory.legend|escape:'html':'UTF-8'}" class="product_image"><img class="replace-2x" src="{$link->getImageLink($accessory.link_rewrite, $accessory.id_image, 'small')}" alt="{$accessory.legend|escape:'html':'UTF-8'}" {if isset($imgSmallSize)}style="height:{$imgSmallSize.height}px;width:{$imgSmallSize.width}px"{/if} /></a>
						<h5>{if isset($accessory.new) && $accessory.new == 1}<span class="accessory_new">{l s='New'}</span>{/if}<a href="{$accessoryLink|escape:'html':'UTF-8'}" title="{$accessory.legend|escape:'html':'UTF-8'}">{$accessory.name|truncate:50:'...'|escape:'html':'UTF-8'}</a></h5>
						{*<div class="product_desc">{$accessory.description_short|strip_tags:'UTF-8'|truncate:75:'...'}</div>*}
						{if $accessory.show_price AND !$PS_CATALOG_MODE}
							<p class="price_container">
								<span class="price">{if !$priceDisplay}{convertPrice price=$accessory.price}{else}{convertPrice price=$accessory.price_tax_exc}{/if}</span>
								{*{if isset($accessory.on_sale) && $accessory.on_sale OR isset($accessory.reduction) && $accessory.reduction}<span class="old_price">{convertPrice price=$accessory.price_without_reduction}</span>{/if}*}
								{if isset($accessory.on_sale) && $accessory.on_sale && isset($accessory.show_price) && $accessory.show_price && !$PS_CATALOG_MODE OR isset($accessory.reduction) && $accessory.reduction && isset($accessory.show_price) && $accessory.show_price && !$PS_CATALOG_MODE}
									{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type}
										<span class="accessory_reduction">({if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{convertPrice price=$specific_prices.reduction}{/if})</span>
									{/if}
								{/if}
							</p>
						{/if}
						<p class="accessory_buttons">
							{if !isset($ptm_listbuttons) OR isset($ptm_listbuttons) AND $ptm_listbuttons != none}
								{if !isset($ptm_listbuttons) OR isset($ptm_listbuttons) AND ($ptm_listbuttons == addcart || $ptm_listbuttons == both)}
									{if !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
										{if ($accessory.allow_oosp || $accessory.quantity > 0) && $accessory.available_for_order && $accessory.customizable != 2 && $accessory.minimal_quantity <= 1}
											<a rel="nofollow" class="exclusive ajax_add_to_cart_button" href="{$link->getPageLink('cart.php', true)}?qty=1&amp;id_product={$accessory.id_product|intval}&amp;token={$static_token}&amp;add" data-id-product="{$accessory.id_product|intval}" title="{l s='Add to cart'}">{l s='Add to cart'}</a>
										{else}
											{if isset($accessory.quantity_all_versions) && $accessory.quantity_all_versions > 0}
												<span class="exclusive">{l s='Limited stock'}</span>
											{elseif $accessory.available_for_order && (isset($accessory.quantity_all_versions) && $accessory.quantity_all_versions == 0 || $accessory.quantity <= 0)}
												<span class="exclusive">{l s='Out of stock'}</span>
											{elseif !$accessory.available_for_order}
												<span class="exclusive">{l s='Unavailable'}</span>
											{else}
												<span class="exclusive">{l s='See details'}</span>
											{/if}
										{/if}
									{/if}
								{/if}
								{if !isset($ptm_listbuttons) OR isset($ptm_listbuttons) AND ($ptm_listbuttons == view || $ptm_listbuttons == both)}
									<a class="button" href="{$accessoryLink|escape:'html':'UTF-8'}" title="{l s='View'}"><i class="icon-magnifier"></i></a>
								{/if}
							{/if}
						</p>
					</li>
				{/foreach}
				</ul>
			</div>
		</li></ul>
	</div>
{/if}

{if isset($packItems) && $packItems|@count > 0}
	<div id="blockpack">
		<ul class="idTabs idTabsShort">
			<li><a class="selected">{l s='Pack content'}</a></li>
		</ul>
		<div class="blockpack_content">
			{include file="$tpl_dir./product-list.tpl" products=$packItems}
		</div>
	</div>
{/if}

{if isset($HOOK_PRODUCT_TAB) && $HOOK_PRODUCT_TAB}
<div id="hook_product_tab">
	<ul class="idTabs idTabsShort clearfix">
		{$HOOK_PRODUCT_TAB}
	</ul>
	<div class="sheets align_justify">
	{if isset($HOOK_PRODUCT_TAB_CONTENT) && $HOOK_PRODUCT_TAB_CONTENT}{$HOOK_PRODUCT_TAB_CONTENT}{/if}
	<div itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">
		<span class="hidden" itemprop="ratingValue">{if isset($averageTotal) AND $averageTotal|round != 0}{$averageTotal|round}{else}5{/if}</span>
		<span class="hidden" itemprop="reviewCount">{if isset($comments)}{$comments|@count}{/if}</span>
	</div>
	</div>
</div>
{/if}

</div>

{if isset($HOOK_PRODUCT_FOOTER) && $HOOK_PRODUCT_FOOTER}{$HOOK_PRODUCT_FOOTER}{/if}

{/if}

{/if}