{*
* Template Prestashop BioCosmetic
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

<!-- MODULE Block new products HOME -->
<div id="new-products_block_center" class="block products_block tab-pane">
	<h4><a href="{$link->getPageLink('new-products.php')}" title="{l s='New products' mod='blocknewproducts'}">{l s='New products' mod='blocknewproducts'}</a></h4>
	{if $new_products !== false}
		<div class="block_content">
			{if isset($ptm_homeproducts) && $ptm_homeproducts == 3}{assign var='spanValue' value=4}{/if}
			{if isset($ptm_homeproducts) && $ptm_homeproducts == 4}{assign var='spanValue' value=3}{/if}
			{if isset($ptm_homeproducts) && $ptm_homeproducts == 5}{assign var='spanValue' value=2}{/if}
			{if isset($ptm_homeproducts)}
				{assign var='nbItemsPerLine' value=$ptm_homeproducts}
			{else}
				{assign var='nbItemsPerLine' value=4}
				{assign var='spanValue' value=3}
			{/if}
			<ul class="clearfix">
				{foreach from=$new_products item=product name=myLoop}
					<li class="ajax_block_product {if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}{if $smarty.foreach.myLoop.iteration%$nbItemsPerLine == 0} last_item_of_line{elseif $smarty.foreach.myLoop.iteration%$nbItemsPerLine == 1} first_item_of_line{/if} span{$spanValue}">
						{if isset($product.new) && $product.new == 1}<a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}"><span class="new">{l s='New' mod='blocknewproducts'}</span></a>{/if}
						<div class="left_block">
							<div class="product_img_container">
								<a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}" class="product_image">
									<img class="replace-2x" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home')}" alt="{$product.name|escape:'html':'UTF-8'}" />
								</a>
								{if !isset($ptm_quickview) OR isset($ptm_quickview) AND $ptm_quickview == 1}
									<a class="quick-view" href="{$product.link|escape:'html':'UTF-8'}">
										<span>{l s='Quick view' mod='blocknewproducts'}</span>
									</a>
								{/if}
							</div>
							<h5><a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}">{$product.name|truncate:45:'...'|escape:'html':'UTF-8'}</a></h5>
							{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
								{hook h='displayProductListReviews' product=$product}
							{/if}
							<div class="product_desc">{$product.description_short|strip_tags:'UTF-8'|truncate:100:'...'}</div>
							<a class="lnk_view" href="{$product.link|escape:'html':'UTF-8'}" title="{l s='View this product' mod='blocknewproducts'}">{l s='View this product' mod='blocknewproducts'}</a>
						</div>
						<div class="right_block">
							{assign var='specific_prices' value=$product.specific_prices}
							{if isset($product.on_sale) && $product.on_sale && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE OR isset($product.reduction) && $product.reduction && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
								{if isset($specific_prices.reduction_type) && $specific_prices.reduction_type}
									<p class="reduction">{if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{convertPrice price=$specific_prices.reduction}{/if}</p>
								{/if}
							{/if}
							{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
								<p class="price_container">
									{if isset($product.show_price) && $product.show_price}
										<span class="price">{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayProductPriceBlock" product=$product type="before_price"}{/if}{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}</span>
										{if isset($product.on_sale) && $product.on_sale && $product.reduction > 0 OR isset($product.reduction) && $product.reduction && $product.reduction > 0}<span class="old_price_display">{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayProductPriceBlock" product=$product type="old_price"}{/if}<span class="old_price">{convertPrice price=$product.price_without_reduction}</span></span>{/if}
									{/if}
								</p>
								{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
									<div class="aeuc_block">
										{hook h="displayProductPriceBlock" product=$product type="price"}
										{hook h="displayProductPriceBlock" product=$product type="weight"}
										{hook h="displayProductPriceBlock" product=$product type='after_price'}
									</div>
								{/if}
							{/if}
							{if isset($product.online_only) && $product.online_only}<p class="online_only">{l s='Online only !' mod='blocknewproducts'}</p>{/if}
							{if isset($product.available_for_order) && $product.available_for_order && !$PS_CATALOG_MODE && $PS_STOCK_MANAGEMENT}
								{if ($product.allow_oosp AND $product.quantity > 0 || $product.quantity > 0)}
									<p class="available">{if isset($product.available_now) && $product.available_now}{$product.available_now}{else}{l s='Available' mod='blocknewproducts'}{/if}</p>
								{elseif ($product.allow_oosp AND $product.quantity <= 0 AND $product.quantity_all_versions <= 0)}
									<p class="available_later">{if isset($product.available_later) && $product.available_later}{$product.available_later}{else}{l s='Preorder' mod='blocknewproducts'}{/if}</p>
								{elseif (isset($product.quantity_all_versions) && $product.quantity_all_versions > 0)}
									<p class="available_later">{l s='Available with different options' mod='blocknewproducts'}</p>
								{else}
									<p class="unavailable">{l s='Out of stock' mod='blocknewproducts'}</p>
								{/if}
							{/if}
							{if !$product.available_for_order}
								<p class="unavailable">{l s='Unavailable product' mod='blocknewproducts'}</p>
							{/if}
						</div>
						<div>
							{if !isset($ptm_homebuttons) OR isset($ptm_homebuttons) AND $ptm_homebuttons != none}
								{if !isset($ptm_homebuttons) OR isset($ptm_homebuttons) AND ($ptm_homebuttons == view || $ptm_homebuttons == both)}
									<a class="button{if isset($ptm_homebuttons) AND $ptm_homebuttons == view} fullwidth{/if}" href="{$product.link|escape:'html':'UTF-8'}" title="{l s='View' mod='blocknewproducts'}"><i class="icon-magnifier"></i></a>
								{/if}
								{if !isset($ptm_homebuttons) OR isset($ptm_homebuttons) AND ($ptm_homebuttons == addcart || $ptm_homebuttons == both)}
									{if ($product.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
										{if ($product.allow_oosp || $product.quantity > 0) && $product.available_for_order && $product.customizable != 2 && $product.minimal_quantity <= 1}
											<a rel="nofollow" class="exclusive ajax_add_to_cart_button{if isset($ptm_homebuttons) AND $ptm_homebuttons == addcart} fullwidth{/if}" data-id-product="{$product.id_product}" href="{$link->getPageLink('cart.php', true)}?qty=1&amp;id_product={$product.id_product}&amp;token={$static_token}&amp;add" title="{l s='Add to cart' mod='blocknewproducts'}">{l s='Add to cart' mod='blocknewproducts'}</a>
										{else}
											{if isset($product.quantity_all_versions) && $product.quantity_all_versions > 0}
												<span class="exclusive{if isset($ptm_homebuttons) AND $ptm_homebuttons == addcart} fullwidth{/if}">{l s='Limited stock' mod='blocknewproducts'}</span>
											{elseif $product.available_for_order && (isset($product.quantity_all_versions) && $product.quantity_all_versions == 0 || $product.quantity <= 0)}
												<span class="exclusive{if isset($ptm_homebuttons) AND $ptm_homebuttons == addcart} fullwidth{/if}">{l s='Out of stock' mod='blocknewproducts'}</span>
											{elseif !$product.available_for_order}
												<span class="exclusive{if isset($ptm_homebuttons) AND $ptm_homebuttons == addcart} fullwidth{/if}">{l s='Unavailable' mod='blocknewproducts'}</span>
											{else}
												<span class="exclusive{if isset($ptm_homebuttons) AND $ptm_homebuttons == addcart} fullwidth{/if}">{l s='See details' mod='blocknewproducts'}</span>
											{/if}
										{/if}
									{/if}
								{/if}
							{/if}
						</div>
					</li>
				{/foreach}
			</ul>
		</div>
	{else}
		<p>{l s='No new products at this time' mod='blocknewproducts'}</p>
	{/if}
</div>
<!-- /MODULE Block new products HOME -->