/**
* Template Prestashop BioCosmetic
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

// Show the order-details with ajax
function showOrder(mode, var_content, file) {
	$.get(
		file,
		((mode == 1) ? {'id_order': var_content, 'ajax': true} : {'id_order_return': var_content, 'ajax': true}),
		function(data) {
			$('#block-order-detail').fadeOut('slow', function() {
				$(this).html(data);
				// If return is allowed
				if ($('div#order-detail-content table td.order_cb').length > 0) {
					// Return slip : check or uncheck every checkboxes
					$('form div#order-detail-content th input[type=checkbox]').click(function() {
							$('form div#order-detail-content td input[type=checkbox]').each(function() {
								this.checked = $('form div#order-detail-content th input[type=checkbox]').is(':checked');
								updateOrderLineDisplay(this);
							});
					});
					// Return slip : enable or disable 'global' quantity editing
					$('form div#order-detail-content td input[type=checkbox]').click(function() {
						updateOrderLineDisplay(this);
					});
					// Return slip : limit quantities
					$('form div#order-detail-content td input.order_qte_input').keyup(function() {
						var maxQuantity = parseInt($(this).parent().find('span.order_qte').text());
						var quantity = parseInt($(this).val());
						if (isNaN($(this).val()) && $(this).val() != '') {
							$(this).val(maxQuantity);
						} else {
							if (quantity > maxQuantity)
								$(this).val(maxQuantity);
							else if (quantity < 1)
								$(this).val(1);
						}
					});
				}
				$('form#sendOrderMessage').submit(function() {
					return sendOrderMessage();
			});
			$(this).fadeIn('slow', function() {
				$.scrollTo(this, 1200);
				if(typeof(resizeAddressesBox) == 'function')
					resizeAddressesBox();
			});
		});
	});
}

function updateOrderLineDisplay(domCheckbox) {
	var lineQuantitySpan = $(domCheckbox).parent().parent().find('span.order_qte');
	var lineQuantityInput = $(domCheckbox).parent().parent().find('input.order_qte_input');
	if ($(domCheckbox).is(':checked')) {
		lineQuantitySpan.hide();
		lineQuantityInput.show();
	} else {
		lineQuantityInput.hide();
		lineQuantityInput.val(lineQuantitySpan.text());
		lineQuantitySpan.show();
	}
}

// Send a message in relation to the order with ajax
function sendOrderMessage() {
	paramString = "ajax=true";
	$('form#sendOrderMessage').find('input, textarea').each(function() {
		paramString += '&' + $(this).attr('name') + '=' + encodeURI($(this).val());
	});

	$.ajax({
		type: "POST",
		url: $('form#sendOrderMessage').attr("action"),
		data: paramString,
		success: function (msg) {
			$('#block-order-detail').fadeOut('slow', function() {
				$(this).html(msg);
				$('form#sendOrderMessage').submit(function() {
					return sendOrderMessage();
				});
				$(this).fadeIn('slow');
			});
		}
	});
	return false;
}