<?php

class WPSmartCodesRenderer
{
    private $_out = '';
    private $_params = array();

    public function __construct($content = null)
    {
        // Set params
        $this->_params['content'] = $content;
    }

    private function attributesSetter($defaults, $attributes)
    {
        foreach ($defaults as $attrName => $attrValue)
        {
            if (isset($attributes[$attrName]) && $attributes[$attrName] != '' && $attributes[$attrName] != $defaults[$attrName]){
                $defaults[$attrName] = $attributes[$attrName];
            }
        }

        return $defaults;
    }

    /*----------------------------------------------------------------*/
    /* Row (Enclosing)
    /*----------------------------------------------------------------*/
    public function row($attributes)
    {
        $defaults = array(
            'class' => ''
        );

        $attributes = $this->attributesSetter($defaults, $attributes);

        $this->_out = '<div class="row ' . ($attributes['class'] != '' ? $attributes['class'] : '') . '">' . WPSmartCodesProcessor::wpProcessSmartCodes($this->_params) . '</div>';

        return $this->_out;
    }

    /*----------------------------------------------------------------*/
    /* Column (Enclosing)
    /*----------------------------------------------------------------*/
    public function column($attributes)
    {
        $defaults = array(
            'col' => '12-12',
            'class' => ''
        );

        $attributes = $this->attributesSetter($defaults, $attributes);

        $this->_out = '<div class="column col-' . $attributes['col'] . ' ' . ($attributes['class'] != '' ? $attributes['class'] : '') . '">' . WPSmartCodesProcessor::wpProcessSmartCodes($this->_params) . '</div>';

        return $this->_out;
    }

    /*----------------------------------------------------------------*/
    /* TabGroup (Enclosing)
    /*----------------------------------------------------------------*/
    public function tabgroup($attributes)
    {
        $defaults = array(
            'id' => 'tab-1',
            'class' => ''
        );

        //$out = 'Tabs begining';

        $this->_out = WPSmartCodesProcessor::wpProcessSmartCodes($this->_params);

        //$out .= 'Tabs ending';

        return $this->_out;
    }

    /*----------------------------------------------------------------*/
    /* Tab (Enclosing)
    /*----------------------------------------------------------------*/
    public function tab($attributes)
    {
        $this->_out = WPSmartCodesProcessor::wpProcessSmartCodes($this->_params);

        return $this->_out;
    }

    /*----------------------------------------------------------------*/
    /* Icon (Self-closing)
    /*----------------------------------------------------------------*/
    public function icon($attributes)
    {
        $defaults = array(
            'type' => 'wpicon-cart',
            'size' => 'medium',
            'class' => ''
        );

        $attributes = $this->attributesSetter($defaults, $attributes);

        $this->_out = '<span class="wpicon ' . $attributes['type'] . ' ' . $attributes['size'] . ' ' . ($attributes['class'] != '' ? $attributes['class'] : '') . '">' . WPSmartCodesProcessor::wpProcessSmartCodes($this->_params) . '</span>';

        return $this->_out;
    }

    /*----------------------------------------------------------------*/
    /* Button (Enclosing)
    /*----------------------------------------------------------------*/
    public function button($attributes)
    {
        $defaults = array(
            'link' => '',
            'target' => '',
            'type' => 'button-1 fill',
            'class' => '',
        );

        $attributes = $this->attributesSetter($defaults, $attributes);

        $this->_out = '<a' . ($attributes['link'] != '' ? ' href="' . $attributes['link'] . '"' : '') . ($attributes['target'] != '' ? ' target="' . $attributes['target'] . '"' : '') . ' class="' . $attributes['type'] . ' inline ' . ($attributes['class'] != '' ? $attributes['class'] : '') . '">' . WPSmartCodesProcessor::wpProcessSmartCodes($this->_params) . '</a>';

        return $this->_out;
    }

}