{if isset($wpblogcustomblockb) && $wpblogcustomblockb}
    <div id="wpblogcustomblockb-home" class="row parent">
        {if isset($wpblogcustomblockb.title) && $wpblogcustomblockb.title}
            <div class="row">
                <div class="column col-12-12 title-1">
                    {$wpblogcustomblockb.title}
                    <div class="blog-link align-right"><a href="{$wpblogcustomblockb.blogLink}">{l s='Visit the blog' mod='wpblogcustomblockb'}</a></div>
                </div>
            </div>
        {/if}

        {if isset($wpblogcustomblockb.posts) && $wpblogcustomblockb.posts}
            <div class="row">
                <ul id="wpblogcustomblockb-posts" class="grid grid-4">
                    {foreach $wpblogcustomblockb.posts as $post}
                        <li class="item">
                            <div class="item-wrapper">
                                {if (isset($post.featuredImage) && $post.featuredImage)}
                                    <div class="item-upper-container white-border-3px">
                                        <a class="post-image" href="{$post.link}">
                                            <img class="item-image-cover" src="{$wpblogcustomblockb.blogImageDir}{$post.featuredImage}-smallsqr.jpg">
                                        </a>
                                    </div>
                                {elseif (isset($post.video_embed) && $post.video_embed)}
                                    <div class="item-upper-container white-border-3px">
                                        <a class="post-image" href="{$post.link}">
                                            <img class="item-image-cover" src="{$wpblogcustomblockb.blogImageDir}videoplaceholder-smallsqr.jpg">
                                        </a>
                                    </div>
                                {/if}
                                <div class="item-details">
                                    <span class="post-name">
                                        <a href="{$post.link}">{$post.name|truncate:60:'...'|escape:'UTF-8'}</a>
                                    </span>

                                    <span class="post-published">
                                        {$post.published_on}
                                    </span>

                                    <span class="post-teaser">
                                        {if ($post.teaser != '')}
                                            {$post.teaser|truncate:120:'...'|escape:'html':'UTF-8'}
                                        {else}
                                            {$post.post|truncate:120:'...'|strip_tags|escape:'UTF-8'}
                                        {/if}
                                    </span>

                                    <span class="post-readmore">
                                        <a class="button-1 outline inline" href="{$post.link}">
                                            <span class="wpicon wpicon-arrow-right2"></span>{l s='Read more' mod='wpblogcustomblockb'}
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </li>
                    {/foreach}
                </ul>
            </div>

        {else}
            {l s='There are no posts to show!' mod='wpblogcustomblockb'}
        {/if}
    </div>
{/if}