<?php

/* Withinpixels - Blog Categories Module - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

class WPBlogCategories extends Module {

    private $_catTree;
    private $_output;
    private $_customHooks = array();

    function __construct() {
                
        $this->name = 'wpblogcategories';
        $this->tab = 'front_office_features';
        $this->version = '1.0';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Withinpixels - Blog Categories');
        $this->description = $this->l('Blog categories block for sidebar');

        $this->_customHooks = array(
            1 => 'displayWPBlogSidebar'
        );
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()){
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
               && $this->registerHook('displayHeader')
               && $this->registerHook('displayLeftColumn')
               && $this->registerCustomHooks()
               && $this->createConfig();

    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {

        return parent::uninstall()
               && $this->unregisterHook('displayHeader')
               && $this->unregisterHook('displayLeftColumn')
               && $this->unregisterCustomHooks()
               && $this->removeConfig();

    }
    
    
    /* ------------------------------------------------------------- */
    /*  REGISTER CUSTOM HOOKS
    /* ------------------------------------------------------------- */
    protected function registerCustomHooks()
    {
        $response = true;

        foreach ($this->_customHooks as $key => $name)
        {
            $hookId = Hook::getIdByName($name);
            if ($hookId){
                $this->registerHook($name);
                continue;
            }

            $newHook = new Hook();
            $newHook->name = $name;
            $newHook->title = $name;
            $newHook->live_edit = 0;
            $newHook->position = 1; // This is why we are doing this whole thing..
            $newHook->add();

            $newHookId = $newHook->id;

            if (!$newHookId){
                $response &= false;
            } else {
                $this->registerHook($name);
            }

        }

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  UNREGISTER CUSTOM HOOKS
    /* ------------------------------------------------------------- */
    protected function unregisterCustomHooks()
    {
        $response = true;

        foreach ($this->_customHooks as $key => $name){
            $response &= $this->unregisterHook($name);
        }

        return $response;
    }


    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    protected function createTables()
    {
        return true;
    }

    
    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    protected function deleteTables()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE DATA
    /* ------------------------------------------------------------- */
    protected function installData()
    {
        return true;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE TAB
    /* ------------------------------------------------------------- */
    public function installTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE TAB
    /* ------------------------------------------------------------- */  
    public function uninstallTab()
    {
		return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  CREATE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function createConfig()
    {
        // Options
        $response = Configuration::updateValue('WPBLOG_BLOGCAT_HIDEEMPTY', 0);

        return $response;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REMOVE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function removeConfig()
    {
        // Options
        $response = Configuration::deleteByName('WPBLOG_BLOGCAT_HIDEEMPTY');

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  MODULE INITIALIZE & FORM SUBMIT CHECKs
    /* ------------------------------------------------------------- */
    public function getContent()
    {
        // Make sure wpblog module is installed and enabled
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            $this->_output = $this->displayError($this->l('This module requires "Withinpixels - Blog" module, make sure it is installed and enabled!'));
            return $this->_output;
        }

        $errors = array();

        if (Tools::isSubmit('submit'.$this->name)){

            // Hide the category if empty
            if (Tools::isSubmit('wpblog_blogcat_hideempty')){
                Configuration::updateValue('WPBLOG_BLOGCAT_HIDEEMPTY', Tools::getValue('wpblog_blogcat_hideempty'));
            }

            // Prepare the output
            if (count($errors)){
                $this->_output .= $this->displayError(implode('<br />', $errors));
            } else {
                $this->_output .= $this->displayConfirmation($this->l('Configuration updated'));
            }

        }

        return $this->_output.$this->displayForm();
    }


    /* ------------------------------------------------------------- */
    /*  DISPLAY CONFIGURATION FORM
    /* ------------------------------------------------------------- */
    public function displayForm()
    {
        // Get default Language
        $id_default_lang = $this->context->language->id;
        $languages = $this->context->language->getLanguages();
        $id_shop = $this->context->shop->id;

        $fields_form = array(
            'wpblogcategories-general' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('General'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Hide empty categories'),
                            'name' => 'wpblog_blogcat_hideempty',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'hideempty_on',
                                    'value' => 1,
                                    'label' => $this->l('Hide')
                                ),
                                array(
                                    'id' => 'hideempty_off',
                                    'value' => 0,
                                    'label' => $this->l('Show')
                                )
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveOptions'
                    )
                )
            )
        );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $id_default_lang;
        $helper->allow_employee_form_lang = $id_default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' => array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
            )
        );

        $helper->fields_value['wpblog_blogcat_hideempty'] = Configuration::get('WPBLOG_BLOGCAT_HIDEEMPTY');

        return $helper->generateForm($fields_form);

    }

    /* ------------------------------------------------------------- */
    /*
    /* FRONT OFFICE
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */
    private function _prepHook($params)
    {
        if ( !Module::isInstalled('wpblog') || !Module::isEnabled('wpblog') ){
            return false;
        }

        if (file_exists(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogCategoryModel.php')){
            include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogCategoryModel.php');
        } else {
            return false;
        }

        $id_shop = $this->context->shop->id;

        $blogCategories = $this->renderCategories(WPBlogCategoryModel::getBlogCategories($id_shop));

        $this->smarty->assign('blogCategories', $blogCategories);

    }


    /* ------------------------------------------------------------- */
    /*  RENDER CATEGORIES
    /* ------------------------------------------------------------- */
    private function renderCategories($categories)
    {
        if (!$categories){
            return false;
        }

        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;

        foreach ($categories as $category)
        {
            // ID
            $catID = $category['id_wpblog_cats'];

            $wpBlogCategory = new WPBlogCategoryModel($category['id_wpblog_cats'], $id_default_lang);

            if (!$wpBlogCategory->active){
                continue;
            }

            // Post Count
            $postCount = $wpBlogCategory->getPostCount($catID, $id_shop);

            if (Configuration::get('WPBLOG_BLOGCAT_HIDEEMPTY') && $postCount == 0){
                continue;
            }

            // Name
            $catName = $wpBlogCategory->name;

            // Link
            $catLink = $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $category['id_wpblog_cats'], 'rewrite' => $wpBlogCategory->link_rewrite));

            // Depth
            $catDepth = $wpBlogCategory->depth;


            $this->_catTree[] = array(
                'id_wpblog_cats' => $catID,
                'name' => $catName,
                'link' => $catLink,
                'depth' => $catDepth + 1,
                'post_count' => $postCount
            );

            if (!empty($category['children'])){
                $this->renderCategories($category['children']);
            }
        }

        return $this->_catTree;
    }

    /* ------------------------------------------------------------- */
    /*  HOOK (displayLeftColumn)
    /* ------------------------------------------------------------- */
    public function hookDisplayLeftColumn($params)
    {
        $this->_prepHook($params);
        return $this->display(__FILE__, 'wpblogcategories.tpl');
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayWPBlogSidebar)
    /* ------------------------------------------------------------- */
    public function hookDisplayWPBlogSidebar($params)
    {
        return $this->hookDisplayLeftColumn($params);
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayHeader)
    /* ------------------------------------------------------------- */
    public function hookDisplayHeader($params)
    {
        $this->context->controller->addCSS($this->_path . 'views/css/hook/wpblogcategories.css');
        $this->context->controller->addJqueryPlugin('wpblogcategories', $this->_path . 'views/js/hook/');
    }

}
