<div class="wpblog-post-single post-id-{$post.id_wpblog_posts}">

        <div class="post-header">
            
            <h2 class="post-title">
                <a href="{$post.link}">{$post.name}</a>
            </h2>

            <div class="post-meta">
                {if $WPBLOG_SHOW_AUTHOR}
                    <span class="post-author"><span class="wpicon wpicon-user medium"></span>{$post.author}</span>
                    <span class="post-meta-separator"></span>
                {/if}

                <span class="post-published-on"><span class="wpicon wpicon-calendar medium"></span>{$post.published_on}</span>

                {if isset($post.view_count) && $post.view_count}
                    <span class="post-meta-separator"></span>
                    <span class="post-view-count"><span class="wpicon wpicon-eye2 medium"></span>{$post.view_count} {if ($post.view_count == 1)}{l s='view' mod='wpblog'}{else}{l s='views' mod='wpblog'}{/if}</span>
                {/if}

                {if (isset($post.alltags) && $post.alltags)}
                    <span class="post-meta-separator"></span>
                    <span class="wpicon colored-text wpicon-tag medium"></span>
                    {foreach $post.alltags as $tag}
                        <a href="{$tag.link}">{$tag.tag|strip_tags|escape:'html':'UTF-8'}</a>{if !$tag@last}, {/if}
                    {/foreach}
                {/if}
                
                <span class="post-meta-separator"></span>
                <span class="wpicon colored-text wpicon-menu medium"></span>
                {foreach $post.postCategories as $postCategory}
                    <a href="{$postCategory.link}">{$postCategory.name}</a>{if !$postCategory@last}, {/if}
                {/foreach}
                
            </div>

        </div>
        
        {if ($post.type == 'standard')}

            {if (isset($post.featuredImage) && $post.featuredImage)}
                <a class="post-image fancybox" href="{$blogImageDir}{$post.featuredImage}.jpg">
                    <span class="post-image-hover"></span>
                    <img src="{$blogImageDir}{$post.featuredImage}.jpg">
                </a>
            {/if}

        {elseif ($post.type == 'gallery')}

            {if (isset($post.allImages) && $post.allImages)}
                <div class="post-gallery">
                    {foreach $post.allImages as $postImage}
                        <a class="post-image fancybox" href="{$blogImageDir}{$postImage.filename}.jpg" rel="post-images-gallery-{$post.id_wpblog_posts}">
                            <span class="post-image-hover"></span>
                            <img src="{$blogImageDir}{$postImage.filename}-smallsqr.jpg">
                        </a>
                    {/foreach}
                </div>
            {/if}
            
        {elseif ($post.type == 'slider')}
            
            {if (isset($post.allImages) && $post.allImages)}
                <div class="post-slider-wrapper">
                    <div class="post-slider-nav-next"><span class="wpicon medium wpicon-chevron-right"></span></div>
                    <div class="post-slider-nav-prev"><span class="wpicon medium wpicon-chevron-left"></span></div>
                    <div class="post-slider">
                        {foreach $post.allImages as $postImage}
                            <img src="{$blogImageDir}{$postImage.filename}.jpg" {if !$postImage@first} style="display: none;"{/if}>
                        {/foreach}
                    </div>
                    <div class="post-slider-pagination"></div>
                </div>
            {/if}
            
        {elseif ($post.type == 'video')}

            {if (isset($post.video_embed) && $post.video_embed)}
                <a class="post-video fancybox" href="#">
                    {$post.video_embed}
                </a>
            {/if}

        {/if}
    
        <div class="post-post normalized">
            {$post.post}
        </div>

        <div class="post-share">
            <!-- AddThis Button BEGIN -->
            <div class="addthis_toolbox addthis_default_style addthis_32x32_style">
                <a class="addthis_button_facebook"></a>
                <a class="addthis_button_twitter"></a>
                <a class="addthis_button_pinterest_share"></a>
                <a class="addthis_button_google_plusone_share"></a>
                <a class="addthis_button_compact"></a><a class="addthis_counter addthis_bubble_style"></a>
            </div>
            <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid={$WPBLOG_POST_ADDTHIS_PUBID}"></script>
            <!-- AddThis Button END -->
        </div>

</div>