{if (($WPBLOG_CAT_VIEW == 'masonry' || $WPBLOG_CAT_VIEW == 'grid') && ($WPBLOG_CAT_COLCOUNT == 1))}
    {$imageSize = ''}
{elseif ((($WPBLOG_CAT_VIEW == 'masonry' || $WPBLOG_CAT_VIEW == 'grid') && $WPBLOG_CAT_COLCOUNT == 2) || ($WPBLOG_CAT_VIEW == 'timeline'))}
    {$imageSize = '-medium'}
{else}
    {$imageSize = '-small'}
{/if}

{if ($WPBLOG_CAT_VIEW == 'timeline')}
    {$post_date = ''}
{/if}

<div class="posts {$WPBLOG_CAT_VIEW} {if $WPBLOG_CAT_VIEW != 'timeline'} grid grid-{$WPBLOG_CAT_COLCOUNT}{/if}">

    {foreach $posts as $post}

        <div class="post post-id-{$post.id_wpblog_posts} item {$post.grid_size}">

            {if ($WPBLOG_CAT_VIEW == 'timeline' && isset($post_date))}
                {if ($post.published_on != $post_date)}
                    <div class="post-date-container">
                        {if ($post_date != '')}
                            <span class="post-date-top-line"></span>
                        {/if}
                        <span class="post-date"><span class="wpicon wpicon-calendar"></span>{$post.published_on}</span>
                        <span class="post-date-bottom-line"></span>
                    </div>
                    {$post_date = $post.published_on}
                {else}
                    <div class="post-main-line-container">
                        <span class="post-main-line"></span>
                    </div>
                {/if}
            {/if}

            {if ($post.type == 'standard')}

                {$standardImageSize = $imageSize}

                {if ($post.grid_size == 'double' && $WPBLOG_CAT_VIEW != 'timeline')}
                    {if ($standardImageSize == '-medium')}
                        {$standardImageSize = ''}
                    {elseif ($standardImageSize == '-small')}
                        {$standardImageSize = '-medium'}
                    {/if}
                {/if}

                {if (isset($post.featuredImage) && $post.featuredImage)}
                    <a class="post-image fancybox" href="{$blogImageDir}{$post.featuredImage}.jpg">
                        <span class="post-image-hover"></span>
                        <img src="{$blogImageDir}{$post.featuredImage}{$standardImageSize}.jpg">
                    </a>
                {/if}

            {elseif ($post.type == 'gallery')}

                {if (isset($post.allImages) && $post.allImages)}
                    <div class="post-gallery">
                        {foreach $post.allImages as $postImage}
                            <a class="post-image fancybox" href="{$blogImageDir}{$postImage.filename}.jpg" rel="post-images-gallery-{$post.id_wpblog_posts}">
                                <span class="post-image-hover"></span>
                                <img src="{$blogImageDir}{$postImage.filename}-smallsqr.jpg">
                            </a>
                        {/foreach}
                    </div>
                {/if}

            {elseif ($post.type == 'slider')}

                {$sliderImageSize = $imageSize}

                {if ($post.grid_size == 'double' && $WPBLOG_CAT_VIEW != 'timeline')}
                    {if ($sliderImageSize == '-medium')}
                        {$sliderImageSize = ''}
                    {elseif ($sliderImageSize == '-small')}
                        {$sliderImageSize = '-medium'}
                    {/if}
                {/if}

                {if (isset($post.allImages) && $post.allImages)}
                    <div class="post-slider-wrapper">
                        <div class="post-slider-nav-next"><span class="wpicon medium wpicon-chevron-right"></span></div>
                        <div class="post-slider-nav-prev"><span class="wpicon medium wpicon-chevron-left"></span></div>
                        <div class="post-slider">
                            {foreach $post.allImages as $postImage}
                                <img src="{$blogImageDir}{$postImage.filename}{$sliderImageSize}.jpg" {if !$postImage@first} style="display: none;"{/if}>
                            {/foreach}
                        </div>
                        <div class="post-slider-pagination"></div>
                    </div>
                {/if}

            {elseif ($post.type == 'video')}

                {if (isset($post.video_embed) && $post.video_embed)}
                    <a class="post-video fancybox" href="#">
                        {$post.video_embed}
                    </a>
                {/if}

            {/if}

            <div class="post-content">

                <h2 class="post-title">
                    <a href="{$post.link}">{$post.name|truncate:60:'...'|escape:'UTF-8'}</a>
                </h2>

                <div class="post-meta colored-text">
                    {if $WPBLOG_SHOW_AUTHOR}
                        <span class="post-author"><span class="wpicon wpicon-user medium"></span>{$post.author}</span>
                        <span class="post-meta-separator"></span>
                    {/if}

                    <span class="post-published-on"><span class="wpicon wpicon-calendar medium"></span>{$post.published_on}</span>

                    {if isset($post.allow_comments) && $post.allow_comments}
                        <span class="post-meta-separator"></span>
                        <span class="post-comment-count"><span class="wpicon wpicon-bubble-dots medium"></span>{$post.comments_count}</span>
                    {/if}

                    {if isset($post.view_count) && $post.view_count}
                        <span class="post-meta-separator"></span>
                        <span class="post-view-count"><span class="wpicon wpicon-eye2 medium"></span>{$post.view_count}</span>
                    {/if}
                </div>

                <div class="post-teaser">
                    {if ($post.teaser != '')}
                        {$post.teaser|truncate:200:'...'|escape:'html':'UTF-8'}
                    {else}
                        {$post.post|truncate:200:'...'|strip_tags|escape:'UTF-8'}
                    {/if}
                </div>

                <div class="post-readmore">
                    <a class="button-1 outline" href="{$post.link}">
                        <span class="wpicon wpicon-arrow-right2"></span>{l s='Read more' mod='wpblog'}
                    </a>
                </div>

            </div>

        </div>

    {/foreach}

</div>