<div class="posts">

    <ul class="grid grid-4">
        {foreach $latestPosts as $post}
            <li class="post post-id-{$post.id_wpblog_posts} item">
                <div class="item-wrapper">

                    {if (isset($post.featuredImage) && $post.featuredImage)}
                        <div class="item-upper-container white-border-3px">
                            <a class="post-image" href="{$post.link}">
                                <img class="item-image-cover" src="{$blogImageDir}{$post.featuredImage}-smallsqr.jpg">
                            </a>
                        </div>
                    {elseif (isset($post.video_embed) && $post.video_embed)}
                        <div class="item-upper-container white-border-3px">
                            <a class="post-image" href="{$post.link}">
                                <img class="item-image-cover" src="{$blogImageDir}videoplaceholder-smallsqr.jpg">
                            </a>
                        </div>
                    {/if}

                    <div class="item-details">
                        <span class="post-name">
                            <a href="{$post.link}">{$post.name|truncate:60:'...'|escape:'UTF-8'}</a>
                        </span>

                        <span class="post-published">
                            {$post.published_on}
                        </span>

                        <span class="post-teaser">
                            {if ($post.teaser != '')}
                                {$post.teaser|truncate:120:'...'|escape:'html':'UTF-8'}
                            {else}
                                {$post.post|truncate:120:'...'|strip_tags|escape:'UTF-8'}
                            {/if}
                        </span>

                        <div class="item-buttons">
                            <span class="post-readmore">
                                <a class="button-1 outline" href="{$post.link}">
                                    <span class="wpicon wpicon-arrow-right2"></span>{l s='Read more' mod='wpblog'}
                                </a>
                            </span>
                        </div>
                    </div>

                </div>
            </li>
        {/foreach}
    </ul>

</div>