<?php

class WPBlogPostModel extends ObjectModel
{
    public $id_wpblog_posts;
    public $id_author;
    public $type;
    public $active = 1;
    public $sticky = 0;
    public $comments = 1;
    public $grid_size;
    public $view_count = 0;
    public $group_access;
    public $date_add;
    public $date_upd;
   
    //Multilang Fields
    public $name;
    public $teaser;
    public $post;
    public $tags;
    public $meta_title;
    public $meta_description;
    public $link_rewrite;
    public $video_embed;
    
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'wpblog_posts',
        'primary' => 'id_wpblog_posts',
        'multilang' => true,
        'fields' => array(   
            //Fields
            'id_author'          =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'type'               =>  array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'active'             =>  array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'sticky'             =>  array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'comments'           =>  array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'grid_size'          =>  array('type' => self::TYPE_STRING, 'validate' => 'isCleanHtml'),
            'view_count'          =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'group_access'       =>  array('type' => self::TYPE_STRING),
            'date_add'           =>  array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd'           =>  array('type' => self::TYPE_DATE, 'validate' => 'isDate'),

            //Multilanguage Fields
            'name'              =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'required' => true, 'size' => 250),
            'teaser'            =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml'),
            'post'              =>  array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isCleanHtml', 'required' => true),
            'tags'              =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 250),
            'meta_title'        =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 250),
            'meta_description'  =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 250),
            'link_rewrite'      =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isLinkRewrite', 'required' => true, 'size' => 250),
            'video_embed'       =>  array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isCleanHtml')
        )
    );
        
    public function __construct($id_wpblog_posts = null, $id_lang = null, $id_shop = null)
    {
        Shop::addTableAssociation('wpblog_posts', array('type' => 'shop'));
        parent::__construct($id_wpblog_posts, $id_lang, $id_shop);
    }


    /*-------------------------------------------------------------*/
    /*  ADD
    /*-------------------------------------------------------------*/
    public function add($autodate = true, $null_values = false)
    {
        $context = Context::getContext();
        
        //Call Parent Add Method
        $response = parent::add($autodate, $null_values);
        
        if ($response){
            $this->addBlogPostCategories();
        }
        
        return $response;
    }

    
    /*-------------------------------------------------------------*/
    /*  UPDATE
    /*-------------------------------------------------------------*/
    public function update($null_values = false)
    {
        $this->addBlogPostCategories();
        
        $response = parent::update(true);
        return $response;
    }
    
    
    /*-------------------------------------------------------------*/
    /*  DELETE
    /*-------------------------------------------------------------*/
    public function delete()
    {
        $response = parent::delete();
        
        if ($response){
            $this->deleteBlogPostCategories($this->id_wpblog_posts);
            
            $images = wpBlogPostImages::getImages($this->id_wpblog_posts);
            foreach ($images as $image){
                $wpBlogPostImages = new wpBlogPostImages($image['id_wpblog_post_images']);
                $wpBlogPostImages->delete();
            }
        }
        
        return $response;
        
    }

    /*-------------------------------------------------------------*/
    /*  TEST FOR USER ACCESS
    /*-------------------------------------------------------------*/
    public function isAccessGranted()
    {
        if ($userGroups = Context::getContext()->customer->getGroups()){

            // If the object not set
            if (!isset($this->id_wpblog_posts)){
                return false;
            }

            // Check user groups

            // Post groups are stored in db in different way, so we need to fix that
            $tmpPostGroups = unserialize($this->group_access);
            $postGroups = array();

            foreach ($tmpPostGroups as $groupID => $status){
                if ($status){
                    $postGroups[] = $groupID;
                }
            }

            // Check if groups are intersecting
            $intersect = array_intersect($userGroups, $postGroups);
            if (count($intersect)){
                return true;
            } else {
                return false;
            }
        }
    }

    /*-------------------------------------------------------------*/
    /*  INCREASE THE VIEW COUNT OF THE POST
    /*-------------------------------------------------------------*/
    public function increaseViewCount()
    {
        if (!$this->id){
            return false;
        }

        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->execute(
                        'UPDATE '._DB_PREFIX_.'wpblog_posts
                        SET view_count = view_count + 1
                        WHERE id_wpblog_posts = '.$this->id
                    );

        return $response;
    }

    /*-------------------------------------------------------------*/
    /*  ADD BLOG POST TO SHOPS
    /*-------------------------------------------------------------*/
    public function addBlogPostToShops($id_wpblog_posts)
    {
        $shops = Shop::getShops(true, null, true);

        foreach ($shops as $key => $id_shop){
            $row = array('id_wpblog_posts' => $id_wpblog_posts, 'id_shop' => $id_shop);
            Db::getInstance()->insert('wpblog_posts_shop', $row, false, true, Db::INSERT_IGNORE);
        }
    }
    
    
    /*-------------------------------------------------------------*/
    /*  ADD BLOG CATEGORIES
    /*-------------------------------------------------------------*/
    public function addBlogPostCategories()
    {
        $this->deleteBlogPostCategories((int)$this->id);
        
        if (Tools::isSubmit('blogCategories')){
            $blogCategories = Tools::getValue('blogCategories');
        
            foreach ($blogCategories as $key => $categoryID){
                $row = array('id_wpblog_posts' => (int)$this->id, 'id_wpblog_cats' => (int)$categoryID);
                Db::getInstance()->insert('wpblog_post_cats', $row, false, true, Db::INSERT_IGNORE);
            } 
        } else {
            $row = array('id_wpblog_posts' => (int)$this->id, 'id_wpblog_cats' => 1);
            Db::getInstance()->insert('wpblog_post_cats', $row, false, true, Db::INSERT_IGNORE);
        }
        
    }
     
    
    /*-------------------------------------------------------------*/
    /*  DELETE BLOG CATEGORIES
    /*-------------------------------------------------------------*/
    public function deleteBlogPostCategories($id_wpblog_posts)
    {
        Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'wpblog_post_cats` WHERE `id_wpblog_posts` = '.$id_wpblog_posts);
    }
    
        
    /*-------------------------------------------------------------*/
    /*  GET BLOG CATEGORIES
    /*-------------------------------------------------------------*/
    public static function getBlogPostCategories($id_wpblog_posts)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT `id_wpblog_cats`
            FROM `'._DB_PREFIX_.'wpblog_post_cats`
            WHERE `id_wpblog_posts` = '.$id_wpblog_posts.'
            ');
        
        return $response;
    }


    /*-------------------------------------------------------------*/
    /*  GET BLOG IDs
    /*-------------------------------------------------------------*/
    public static function getBlogPostIDs($id_wpblog_cats = null, $id_shop = null, $start = 0, $limit = 0, $only_active = false, $orderBy = null, $orderWay = null, $sticky = true, $count = false)
    {
        $query = 'SELECT cats.id_wpblog_posts
                  FROM '._DB_PREFIX_.'wpblog_post_cats as cats,
                       '._DB_PREFIX_.'wpblog_posts as posts,
                       '._DB_PREFIX_.'wpblog_posts_shop as shop';

        $whereClause = ' WHERE';

        // Are we using a certain category or calling everything?
        if ($id_wpblog_cats != null){
            $query .= $whereClause . ' cats.id_wpblog_cats = '.$id_wpblog_cats;
            $whereClause = ' AND';
        }

        // Is there any shop limitations
        if ($id_shop != null && Validate::isInt($id_shop)){
            $query .= $whereClause. ' posts.id_wpblog_posts = shop.id_wpblog_posts AND shop.id_shop = '.$id_shop;
            $whereClause = ' AND';
        }

        // Do we grab only active ones?
        if ($only_active == true){
            $query .= $whereClause . ' posts.id_wpblog_posts = cats.id_wpblog_posts AND posts.active = 1';
        }

        // Group the id_wpblog_posts because there might be some posts assigned to multiple categories
        // This will prevent them from taking up more than one space so LIMIT will work correctly
        $query .= ' GROUP BY cats.id_wpblog_posts';

        // Order by and order way
        $query .= ($sticky ? ' ORDER BY posts.sticky DESC, ' : ' ORDER BY ') . ($orderBy == null ? 'posts.date_add' : ($orderBy == 'random' ? 'RAND()' : 'posts.'.$orderBy)) . ' ' . ($orderWay == null ? 'DESC' : $orderWay);
        
        // Limit
        if ($limit > 0){
            $query .= ' LIMIT '.$start.','.$limit;
        }
        
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if ($count){
            return count($response);
        } else {
            return $response;
        }
    }


    /*-------------------------------------------------------------*/
    /*  GET BLOG IDs BY YEAR AND MONTH
    /*-------------------------------------------------------------*/
    public static function getBlogPostIDsByDate($year , $month = 'all', $id_shop = null, $start = 0, $limit = 0, $only_active = false, $orderBy = null, $orderWay = null, $sticky = true, $count = false)
    {
        $query = 'SELECT posts.id_wpblog_posts
                  FROM '._DB_PREFIX_.'wpblog_posts as posts,
                       '._DB_PREFIX_.'wpblog_posts_shop as shop
                  WHERE YEAR(posts.date_add) = '.$year;

        // Is there month value?
        if ($month != 'all'){
            $query .= ' AND MONTH(posts.date_add) = '.$month;
        }

        // Do we grab only active ones?
        if ($only_active == true){
            $query .= ' AND posts.active = 1';
        }

        // Is there any shop limitations
        if ($id_shop != null && Validate::isInt($id_shop)){
            $query .= ' AND posts.id_wpblog_posts = shop.id_wpblog_posts AND shop.id_shop = '.$id_shop;
        }

        // Order by and order way
        $query .= ($sticky ? ' ORDER BY posts.sticky DESC, ' : ' ORDER BY ') . ($orderBy == null ? 'posts.date_add' : $orderBy) . ' ' . ($orderWay == null ? 'DESC' : $orderWay);

        // Limit
        if ($limit > 0){
            $query .= ' LIMIT '.$start.','.$limit;
        }

        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if ($count){
            return count($response);
        } else {
            return $response;
        }
    }


    /*-------------------------------------------------------------*/
    /*  GET BLOG POST MONTHS, YEARS AND COUNTS
    /*-------------------------------------------------------------*/
    public static function getArchiveInfo($id_shop)
    {
        $query = 'SELECT count(posts.id_wpblog_posts) as COUNT, month(posts.date_add) as MONTH, year(posts.date_add) as YEAR
                  FROM '._DB_PREFIX_.'wpblog_posts as posts,
                       '._DB_PREFIX_.'wpblog_posts_shop as shop
                  WHERE posts.id_wpblog_posts = shop.id_wpblog_posts AND shop.id_shop = '.$id_shop.'
                  AND posts.active = 1
                  GROUP BY YEAR, MONTH';

        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        return $response;
    }
}
