<?php
    
class WPBlogCategoryModel extends ObjectModel
{
    private $_catTree = array();
    
    public $id_wpblog_cats;
    public $id_parent_category;
    public $depth;
    public $deletable;
    public $active = 1;
    public $group_access;
    public $date_add;
    public $date_upd;
   
    //Multilang Fields
    public $name;
    public $description;
    public $meta_description;
    public $link_rewrite;
    
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
            'table' => 'wpblog_cats',
            'primary' => 'id_wpblog_cats',
            'multilang' => true,
            'fields' => array(   
                //Fields
                'id_parent_category' =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
                'depth'              =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
                'deletable'          =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
                'active'             =>  array('type' => self::TYPE_INT, 'validate' => 'isBool'),
                'group_access'       =>  array('type' => self::TYPE_STRING),
                'date_add'           =>  array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
                'date_upd'           =>  array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
                
                //Multilanguage Fields
                'name'              =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'required' => true, 'size' => 250),
                'description'       =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 250),
                'meta_description'  =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'size' => 250),
                'link_rewrite'      =>  array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isLinkRewrite', 'required' => true, 'size' => 250),
            )
    );
        
    public function __construct($id_wpblog_cats = null, $id_lang = null, $id_shop = null)
    {
        Shop::addTableAssociation('wpblog_cats', array('type' => 'shop'));
        parent::__construct($id_wpblog_cats, $id_lang, $id_shop);
    }

    /*-------------------------------------------------------------*/
    /*  DELETE
    /*-------------------------------------------------------------*/
    public function delete()
    {
        $deletedId = $this->id;
        
        $response = parent::delete();
       
        if ($response){
            
            $this->checkAndFixPosts($deletedId);
            $children = $this->getChildBlogCategories($deletedId);
            
            if ($children){
                foreach ($children as $child){
                    $wpblogChildCategory = new WPBlogCategoryModel($child['id_wpblog_cats']);
                    if (!Validate::isLoadedObject($wpblogChildCategory)){
                        return false;
                    }

                    $responseChild = $wpblogChildCategory->delete();
                    if($responseChild){
                        $this->checkAndFixPosts($deletedId);
                    }
                }
            }
        }
        
        return true;
    }

    /*-------------------------------------------------------------*/
    /*  TEST FOR USER ACCESS
    /*-------------------------------------------------------------*/
    public function isAccessGranted()
    {
        if ($userGroups = Context::getContext()->customer->getGroups()){

            // If the object not set
            if (!isset($this->id_wpblog_cats)){
                return false;
            }

            // Check user groups

            // Post groups are stored in db in different way, so we need to fix that
            $tmpPostGroups = unserialize($this->group_access);
            $postGroups = array();

            foreach ($tmpPostGroups as $groupID => $status){
                if ($status){
                    $postGroups[] = $groupID;
                }
            }

            // Check if groups are intersecting
            $intersect = array_intersect($userGroups, $postGroups);
            if (count($intersect)){
                return true;
            } else {
                return false;
            }
        }

        return false;
    }


    /*-------------------------------------------------------------*/
    /*  GET ALL CHILD BLOG CATEGORIES BY THE GIVEN PARENT ID
    /*-------------------------------------------------------------*/
    public function getChildBlogCategories($id_parent)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                    'SELECT `id_wpblog_cats`
                    FROM `'._DB_PREFIX_.'wpblog_cats`
                    WHERE `id_parent_category` ='.$id_parent
                    );

        if ($response)
            return $response;
        else
            return false;
    }
    
    
    /*-----------------------------------------------------------------*/
    /*  CHECK AND FIX BLOG POSTS THAT BELONGS TO THE DELETED CATEGORY
    /*-----------------------------------------------------------------*/
    public function checkAndFixPosts($deletedCatId)
    {
        $posts = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                    'SELECT `id_wpblog_posts`, `id_wpblog_cats`
                    FROM `'._DB_PREFIX_.'wpblog_post_cats`
                    WHERE `id_wpblog_cats` ='.$deletedCatId
                    );
        
        foreach ($posts as $post) {
            $postCategories = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                                'SELECT `id_wpblog_posts`, `id_wpblog_cats`
                                FROM `'._DB_PREFIX_.'wpblog_post_cats`
                                WHERE `id_wpblog_posts` ='.$post['id_wpblog_posts']
                                );
            
            if (count($postCategories) > 1)
            {
                Db::getInstance()->execute(
                    'DELETE FROM `'._DB_PREFIX_.'wpblog_post_cats`
                    WHERE `id_wpblog_posts` = '.$post['id_wpblog_posts'].'
                    AND `id_wpblog_cats` = '.$deletedCatId
                    );
            }
            elseif (count($postCategories) == 1)
            {
                Db::getInstance(_PS_USE_SQL_SLAVE_)->execute(
                    'UPDATE '._DB_PREFIX_.'wpblog_post_cats
                    SET `id_wpblog_cats` = 1
                    WHERE `id_wpblog_posts` = '.$post['id_wpblog_posts'].'
                    AND `id_wpblog_cats` =  '.$deletedCatId
                    );
            }
            elseif (count($postCategories) < 1) {
                print ('Database Error!');
                return false;
            }
        }
        
        return true;
    }
    
        
    /*-------------------------------------------------------------*/
    /*  ADD CATEGORIES TO SHOPS
    /*-------------------------------------------------------------*/
    public function addBlogCategoryToShops($id_wpblog_cats)
    {
        $shops = Shop::getShops(true, null, true);
        
        foreach ($shops as $key => $id_shop){
            $row = array('id_wpblog_cats' => $id_wpblog_cats, 'id_shop' => $id_shop);
            Db::getInstance()->insert('wpblog_cats_shop', $row, false, true, Db::INSERT_IGNORE);
        }
    }
    
    /*-------------------------------------------------------------*/
    /*  GET BLOG CATEGORY DEPTH BY ID
    /*-------------------------------------------------------------*/
    public static function getBlogCategoryDepthById($blogCatId)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                    'SELECT `depth`
                    FROM `'._DB_PREFIX_.'wpblog_cats`
                    WHERE `id_wpblog_cats` = '.$blogCatId.'
                    ');
        
        if ($response){
            return $response[0]['depth'];
        } else {
            return 0;
        }
    }
    
    
    /*-------------------------------------------------------------*/
    /*  GET BLOG CATEGORIES
    /*-------------------------------------------------------------*/
    public static function getBlogCategories($id_shop)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                    'SELECT cats.id_wpblog_cats, cats.id_parent_category, cats.depth
                    FROM `'._DB_PREFIX_.'wpblog_cats` as cats,
                         `'._DB_PREFIX_.'wpblog_cats_shop` as shop
                    WHERE shop.id_shop = '.$id_shop.'
                    AND shop.id_wpblog_cats = cats.id_wpblog_cats
                    ORDER BY cats.id_parent_category
                    ');

        $nodeList = array();
        $tree     = array();

        foreach ($response as $row){
            $nodeList[$row['id_wpblog_cats']] = array_merge($row, array('children' => array()));
        }

        foreach ($nodeList as $nodeId => &$node) {
            if ($node['id_parent_category'] == 0 || !array_key_exists($node['id_parent_category'], $nodeList)) {
                $tree[] = &$node;
            } else {
                $nodeList[$node['id_parent_category']]['children'][] = &$node;
            }
        }
        unset($node);
        unset($nodeList);

        return $tree;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  RENDER BLOG CATEGORY TREE
    /* ------------------------------------------------------------- */
    public function renderBlogCategoryTree($id_shop, $id_default_lang, $excludedID = array(), $categories = false, $preFormat = false)
    {
        if (!$categories){
            $categories = $this->getBlogCategories($id_shop);
        }
        
        foreach ($categories as $category){
            if (!in_array($category['id_wpblog_cats'], $excludedID)){
                // ID
                $this->_catTree[$category['id_wpblog_cats']]['id_wpblog_cats'] = $category['id_wpblog_cats'];

                $wpBlogCategory = new WPBlogCategoryModel($category['id_wpblog_cats'], $id_default_lang);
                
                // Name
                if ($preFormat){
                    $this->_catTree[$category['id_wpblog_cats']]['name'] = str_repeat('&mdash;', ($category['depth'])) . ' ' . $wpBlogCategory->name;
                } else {
                    $this->_catTree[$category['id_wpblog_cats']]['name'] = $wpBlogCategory->name;                    
                }
                
                // Depth
                $this->_catTree[$category['id_wpblog_cats']]['depth'] = $wpBlogCategory->depth;
                
                if (!empty($category['children'])){
                    $this->renderBlogCategoryTree($id_shop, $id_default_lang, $excludedID, $category['children'], $preFormat);
                }
            }
        }
        
        return $this->_catTree;
        
    }


    /* ------------------------------------------------------------- */
    /*  GET BLOG POST COUNT OF CERTAIN CATEGORY
    /* ------------------------------------------------------------- */
    public function getPostCount($id_wpblog_cats, $id_shop)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                    'SELECT COUNT(id_wpblog_post_cats)
                    FROM '._DB_PREFIX_.'wpblog_post_cats as postcats
                    LEFT JOIN '._DB_PREFIX_.'wpblog_posts_shop as postsshop
                    ON postcats.id_wpblog_posts = postsshop.id_wpblog_posts
                    WHERE postcats.id_wpblog_cats = '.$id_wpblog_cats.'
                    AND postsshop.id_shop = '.$id_shop
                    );

        return $response[0]['COUNT(id_wpblog_post_cats)'];
    }
}
