<?php

require_once(dirname(__FILE__) . '/../../models/wpBlogPostModel.php');

class wpblogrssModuleFrontController extends ModuleFrontController {

    public function initContent()
    {
        header("Content-Type: text/xml; charset=utf-8");

        $blogRss = $this->prepRss();

        echo $blogRss;

        exit;
    }

    private function prepRss()
    {
        $blogPosts = $this->getBlogPosts();
        $rssChannelInfo = $this->getChannelInfo();

        $blogRss = '';

        if (!$blogPosts){
            return $blogRss;
        }

        $blogRss = '<?xml version="1.0" encoding="utf-8" ?>';
        $blogRss .= '<rss version="2.0">';
        $blogRss .= '<channel>';

        // Channel info
        $blogRss .= '<title>'.$rssChannelInfo['title'].'</title>';
        $blogRss .= '<link>'.$rssChannelInfo['link'].'</link>';
        $blogRss .= '<description>'.$rssChannelInfo['description'].'</description>';
        $blogRss .= '<language>'.$rssChannelInfo['language'].'</language>';

        // Shop logo
        $blogRss .= '<image>';
            $blogRss .= '<url>'.$rssChannelInfo['logo'].'</url>';
            $blogRss .= '<title>'.$rssChannelInfo['title'].'</title>';
            $blogRss .= '<link>'.$rssChannelInfo['link'].'</link>';
        $blogRss .= '</image>';

        // Items
        foreach ($blogPosts as $blogPost)
        {
            $blogRss .= '<item>';
            $blogRss .= '<title>'.$blogPost->name.'</title>';
            $blogRss .= '<link>'.$this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts' => $blogPost->id_wpblog_posts, 'rewrite' => $blogPost->link_rewrite)).'</link>';
            $blogRss .= '<description><![CDATA['.strip_tags($blogPost->post).']]></description>';
            $blogRss .= '<pubDate>'.$blogPost->date_add.'</pubDate>';
            $blogRss .= '</item>';
        }

        $blogRss .= '</channel>';
        $blogRss .= '</rss>';

        return $blogRss;
    }

    private function getBlogPosts()
    {
        $id_shop = $this->context->shop->id;
        $id_lang = $this->context->language->id;

        $postIDs = WPBlogPostModel::getBlogPostIDs(null, $id_shop, 0, 0, true, null, null, false);

        if (!count($postIDs) > 0) {
            return false;
        }

        $blogPosts = array();

        foreach ($postIDs as $postID) {
            $blogPosts[] = new WPBlogPostModel($postID['id_wpblog_posts'], $id_lang);
        }

        return $blogPosts;
    }

    private function getChannelInfo()
    {
        $id_lang = $this->context->language->id;
        $metaTags = Meta::getMetaTags($id_lang, 'index');

        $rssChannelInfo = array();

        $rssChannelInfo['title'] = $metaTags['meta_title'];
        $rssChannelInfo['description'] = $metaTags['meta_description'];
        $rssChannelInfo['link'] = $this->context->link->getModuleLink('wpblog', 'rss');
        $rssChannelInfo['logo'] = $this->context->link->getMediaLink(_PS_IMG_.Configuration::get('PS_LOGO'));
        $rssChannelInfo['language'] = $this->context->language->iso_code;

        return $rssChannelInfo;
    }

}