<?php

require_once(dirname(__FILE__) . '/../custom/wpblogFrontController.php');

class wpblogcategoryModuleFrontController extends wpblogFrontController {

    private $id_wpblog_cats;
    private $rewrite;
    
    // Template
    public $wpblog_template = 'category/category-layout.tpl';
            
    public function __construct()
    {
        parent::__construct();
    }

    public function initContent()
    {
        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        $blogImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . 'wpblog/views/uploads/');

        $pagination_needed = false;

        if (Tools::isSubmit('id_wpblog_cats') && Validate::isInt(Tools::getValue('id_wpblog_cats'))) {
            $this->id_wpblog_cats = Tools::getValue('id_wpblog_cats');
        } else {
            return false;
        }
        
        // Get the category
        $wpBlogCategory = new WPBlogCategoryModel($this->id_wpblog_cats, $id_default_lang, $id_shop);
        
        // Check if we have rights to access
        if (!$wpBlogCategory->isAccessGranted()){
            $this->context->smarty->assign('wp_restricted_access', true);
            parent::initContent();
            return false;
        }

        // Fill page information
        $this->meta_title = $wpBlogCategory->name;
        $this->meta_description = $wpBlogCategory->meta_description;
        
        // Get rewrite link
        $this->rewrite = $wpBlogCategory->link_rewrite;
        
        // Get post count
        $postCount = WPBlogPostModel::getBlogPostIDs($this->id_wpblog_cats, $id_shop, 0, 0, true, null, 'DESC', true, true);

        // Get post limit per page, hard limit = 10 if there is something wrong with the configuration
        if (Configuration::get('WPBLOG_CAT_POST_LIMIT')){
            $limit = Configuration::get('WPBLOG_CAT_POST_LIMIT');
        } else {
            $limit = 10;
        }

        // Check if pagination is needed
        if ($postCount > $limit) {
            $pagination_needed = true;
        }
        
        // Calculate max page count
        $total_pages = (int) ceil($postCount / $limit);
        
        // Get page number from url, if the page number is not valid then do the -barrel roll-, I mean redirect...
        if (Tools::isSubmit('p') && Validate::isInt(Tools::getValue('p'))) {
            if (Tools::getValue('p') <= 0) {
                $this->doRedirect(1);
            } elseif(Tools::getValue('p') > $total_pages) {
                $this->doRedirect($total_pages);
            } else {
                $page = Tools::getValue('p');
            }
        } else {
            $page = 1;
        }
        
        // Calculate the start point
        $start = (int) (($page - 1) * $limit);

        // Get post ids according to the category view type, timeline view won't obey sticky option
        if (Configuration::get('WPBLOG_CAT_VIEW') == 'timeline'){
            $postIDs = WPBlogPostModel::getBlogPostIDs($this->id_wpblog_cats, $id_shop, $start, $limit, true, null, null, false, false);
        } else {
            $postIDs = WPBlogPostModel::getBlogPostIDs($this->id_wpblog_cats, $id_shop, $start, $limit, true);
        }
        
        // If there are posts, then call them all from DB
        if (count($postIDs) > 0) {
            $posts = array();

            foreach ($postIDs as $postID)
            {
                // Get the post
                $wpBlogPost = new WPBlogPostModel($postID['id_wpblog_posts'], $id_default_lang, null);
                
                // If current user's group and post's group access intersecting, then add it to the array
                if (!$wpBlogPost->isAccessGranted()){
                    continue;
                }

                $posts[$wpBlogPost->id_wpblog_posts]['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
                $posts[$wpBlogPost->id_wpblog_posts]['name'] = $wpBlogPost->name;
                $posts[$wpBlogPost->id_wpblog_posts]['teaser'] = $wpBlogPost->teaser;
                $posts[$wpBlogPost->id_wpblog_posts]['post'] = $wpBlogPost->post;
                $posts[$wpBlogPost->id_wpblog_posts]['type'] = $wpBlogPost->type;
                $posts[$wpBlogPost->id_wpblog_posts]['grid_size'] = $wpBlogPost->grid_size;

                if (Configuration::get('WPBLOG_SHOW_VIEWCOUNT')){
                    $posts[$wpBlogPost->id_wpblog_posts]['view_count'] = $wpBlogPost->view_count;
                }

                // Check comment status from both general options and post specific options
                $posts[$wpBlogPost->id_wpblog_posts]['allow_comments'] = false;
                $allow_comments_post = $wpBlogPost->comments;
                $allow_comments_general = Configuration::get('WPBLOG_COMMENTS');

                if ($allow_comments_post && $allow_comments_general) {
                    $posts[$wpBlogPost->id_wpblog_posts]['allow_comments'] = true;
                }

                // Grab stuff according to the post type
                if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
                    $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
                    if ($postImages){
                        $posts[$wpBlogPost->id_wpblog_posts]['allImages'] = $postImages;
                    }
                } elseif ($wpBlogPost->type == 'standard') {
                    $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
                    if ($featuredImage){
                        $posts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $featuredImage['filename'];
                    }
                } elseif ($wpBlogPost->type == 'video') {
                    $posts[$wpBlogPost->id_wpblog_posts]['video_embed'] = $wpBlogPost->video_embed;
                }
                
                // Get the author name
                $employee = New Employee($wpBlogPost->id_author);
                $posts[$wpBlogPost->id_wpblog_posts]['author'] = $employee->firstname;
                
                // Format the date
                $posts[$wpBlogPost->id_wpblog_posts]['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);

                // Get the comment count
                $posts[$wpBlogPost->id_wpblog_posts]['comments_count'] = WPBlogCommentModel::getCommentsCount($wpBlogPost->id_wpblog_posts, $id_shop);
                
                // Create a link to post
                $posts[$wpBlogPost->id_wpblog_posts]['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));
            }
            
            // Get the pagination
            $pagination = new wpblogPagination();
            $pagination->context = $this->context;
            $pagination->current_page = $page;
            $pagination->total_pages = $total_pages;
            $pagination->id_wpblog_cats = $this->id_wpblog_cats;
            $pagination->rewrite = $this->rewrite;
            $paginationHTML = $pagination->createPagination();
            
            // Send stuff to the template
            $this->context->smarty->assign(
                array(
                    'posts'        => $posts,
                    'pagination'   => $paginationHTML,
                    'blogImageDir' => $blogImageDir
                )
            );
        }

        // Assign hooks
        $hooks = array(
            'displayWPBlogSidebar'
        );

        foreach ($hooks as $hook){
            $this->context->smarty->assign('hook_'.$hook, Hook::exec($hook));
        }

        // Send more stuff to the template (these are will be available even if there isn't any post unlike the others)
        $this->context->smarty->assign(
            array(
                'categoryName' => $wpBlogCategory->name,
                'categoryDesc' => $wpBlogCategory->description,
                'postCount'    => $postCount,
                'WPBLOG_SHOW_AUTHOR' => Configuration::get('WPBLOG_SHOW_AUTHOR'),
                'WPBLOG_CAT_SIDEBAR_POS' => Configuration::get('WPBLOG_CAT_SIDEBAR_POS'),
                'WPBLOG_CAT_VIEW' => Configuration::get('WPBLOG_CAT_VIEW'),
                'WPBLOG_CAT_COLCOUNT' => Configuration::get('WPBLOG_CAT_COLCOUNT')
            )
        );
        
        parent::initContent();
    }

    private function doRedirect($page) {
        $link = $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats'=>$this->id_wpblog_cats, 'rewrite'=>$this->rewrite, 'p'=>$page));
        Tools::redirect($link);
    }

}
