<?php

require_once(dirname(__FILE__) . '/../custom/wpblogFrontController.php');

class wpblogblogModuleFrontController extends wpblogFrontController {

    // Template
    public $wpblog_template = 'blog/blog-layout.tpl';
            
    public function __construct()
    {
        parent::__construct();
    }

    public function initContent()
    {
        $id_shop = $this->context->shop->id;
        $id_default_lang = $this->context->language->id;

        $blogImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . 'wpblog/views/uploads/');

        // Fill page information
        $this->meta_title = $this->module->l('Blog');

        // Get featured blog posts

        // Get post limit per page, hard limit = 6 if there is something wrong with the configuration
        if (Configuration::get('WPBLOG_BLOG_FT_POST_LIMIT')){
            $featuredPostCount = Configuration::get('WPBLOG_BLOG_FT_POST_LIMIT');
        } else {
            $featuredPostCount = 6;
        }

        // Featured posts category id is hard coded here (2). This is not good, not even close!
        // But for now it will stay like this!
        // @TODO: Add some sort of a flag column to the table to mark the "Featured" category and use it to get it from db
        $postIDs = WPBlogPostModel::getBlogPostIDs(2, $id_shop, 0, $featuredPostCount, true);
        $featuredPosts = array();

        if (count($postIDs) > 0){
            foreach ($postIDs as $postID)
            {
                // Get the post
                $wpBlogPost = new WPBlogPostModel($postID['id_wpblog_posts'], $id_default_lang);

                // Check if we have rights to access
                if (!$wpBlogPost->isAccessGranted()){
                    continue;
                }

                $featuredPosts[$wpBlogPost->id_wpblog_posts]['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['name'] = $wpBlogPost->name;
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['teaser'] = $wpBlogPost->teaser;
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['post'] = $wpBlogPost->post;
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['type'] = $wpBlogPost->type;
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['grid_size'] = $wpBlogPost->grid_size;

                if (Configuration::get('WPBLOG_SHOW_VIEWCOUNT')){
                    $featuredPosts[$wpBlogPost->id_wpblog_posts]['view_count'] = $wpBlogPost->view_count;
                }

                // Check comment status from both general options and post specific options
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['allow_comments'] = false;
                $allow_comments_post = $wpBlogPost->comments;
                $allow_comments_general = Configuration::get('WPBLOG_COMMENTS');

                if ($allow_comments_post && $allow_comments_general) {
                    $featuredPosts[$wpBlogPost->id_wpblog_posts]['allow_comments'] = true;
                }


                // Grab stuff according to the post type
                if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
                    $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
                    if ($postImages){
                        $featuredPosts[$wpBlogPost->id_wpblog_posts]['allImages'] = $postImages;
                    }
                } elseif ($wpBlogPost->type == 'standard') {
                    $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
                    if ($featuredImage){
                        $featuredPosts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $featuredImage['filename'];
                    }
                } elseif ($wpBlogPost->type == 'video') {
                    $featuredPosts[$wpBlogPost->id_wpblog_posts]['video_embed'] = $wpBlogPost->video_embed;
                }

                // Get the author name
                $employee = New Employee($wpBlogPost->id_author);
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['author'] = $employee->firstname;

                // Format the date
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);

                // Get the comment count
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['comments_count'] = WPBlogCommentModel::getCommentsCount($wpBlogPost->id_wpblog_posts, $id_shop);

                // Create a link to post
                $featuredPosts[$wpBlogPost->id_wpblog_posts]['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));

            }
        }


        // Get latest blog posts

        // Get post limit per page, hard limit = 10 if there is something wrong with the configuration
        if (Configuration::get('WPBLOG_BLOG_LT_POST_LIMIT')){
            $latestPostCount = Configuration::get('WPBLOG_BLOG_LT_POST_LIMIT');
        } else {
            $latestPostCount = 10;
        }

        $postIDs = WPBlogPostModel::getBlogPostIDs(null, $id_shop, 0, $latestPostCount, true, null, null, false);
        $latestPosts = array();

        if (count($postIDs) > 0){
            foreach ($postIDs as $postID)
            {
                // Get the post
                $wpBlogPost = new WPBlogPostModel($postID['id_wpblog_posts'], $id_default_lang);

                // Check if we have rights to access
                if (!$wpBlogPost->isAccessGranted()){
                    continue;
                }

                $latestPosts[$wpBlogPost->id_wpblog_posts]['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
                $latestPosts[$wpBlogPost->id_wpblog_posts]['name'] = $wpBlogPost->name;
                $latestPosts[$wpBlogPost->id_wpblog_posts]['teaser'] = $wpBlogPost->teaser;
                $latestPosts[$wpBlogPost->id_wpblog_posts]['post'] = $wpBlogPost->post;
                $latestPosts[$wpBlogPost->id_wpblog_posts]['type'] = $wpBlogPost->type;
                $latestPosts[$wpBlogPost->id_wpblog_posts]['grid_size'] = $wpBlogPost->grid_size;

                // Grab stuff according to the post type
                if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
                    $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
                    if ($postImages){
                        $latestPosts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $postImages[0]['filename'];
                    }
                } elseif ($wpBlogPost->type == 'standard') {
                    $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
                    if ($featuredImage){
                        $latestPosts[$wpBlogPost->id_wpblog_posts]['featuredImage'] = $featuredImage['filename'];
                    }
                } elseif ($wpBlogPost->type == 'video') {
                    $latestPosts[$wpBlogPost->id_wpblog_posts]['video_embed'] = $wpBlogPost->video_embed;
                }

                // Get the author name
                $employee = New Employee($wpBlogPost->id_author);
                $latestPosts[$wpBlogPost->id_wpblog_posts]['author'] = $employee->firstname;

                // Format the date
                $latestPosts[$wpBlogPost->id_wpblog_posts]['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);

                // Create a link to post
                $latestPosts[$wpBlogPost->id_wpblog_posts]['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));

            }
        }

        // Assign hooks
        $hooks = array(
            'displayWPBlogSidebar'
        );

        foreach ($hooks as $hook){
            $this->context->smarty->assign('hook_'.$hook, Hook::exec($hook));
        }

        // Send stuff to the template
        $this->context->smarty->assign(
            array(
                'latestPosts'  => $latestPosts,
                'featuredPosts'  => $featuredPosts,
                'blogImageDir' => $blogImageDir,
                'WPBLOG_SHOW_AUTHOR' => Configuration::get('WPBLOG_SHOW_AUTHOR'),
                'WPBLOG_BLOG_SIDEBAR_POS' => Configuration::get('WPBLOG_BLOG_SIDEBAR_POS'),
                'WPBLOG_BLOG_FT_VIEW' => Configuration::get('WPBLOG_BLOG_FT_VIEW'),
                'WPBLOG_BLOG_FT_COLCOUNT' => Configuration::get('WPBLOG_BLOG_FT_COLCOUNT')
            )
        );

        parent::initContent();
    }

}
