/**
* Module Prestashop CategoriesTopMenu
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

function changeTab(name) {
	$('#tab_'+id_tab).removeClass('active');
	$('#tab_'+name).addClass('active');
	$('#content_'+id_tab).css('display', 'none');
	$('#content_'+name).css('display', 'block');
	id_tab = name;
	editAreaLoader.init({
		id: "contentCSS",
		syntax: "css",
		start_highlight: true,
		allow_resize: "no",
		allow_toggle: false,
		toolbar: "search, |, go_to_line, |, highlight"
	});
}

$(document).ready(function() {
	$.each($('.colorpickerSelect'),function() {
		var $target = $(this);
		$(this).find('.colorpickerInput').ColorPicker({
			onSubmit: function(hsb, hex, rgb, el) {
				$(el).val(hex);
				$(el).ColorPickerHide();
			},
			onBeforeShow: function() {
				$(this).ColorPickerSetColor(this.value);
			},
			onChange: function(hsb, hex, rgb) {
				$target.find('.colorpickerPreview').css('backgroundColor', '#' + hex);
			}
		})
		.bind('keyup', function() {
			$(this).ColorPickerSetColor(this.value);
		});
	});
});

function nl2br(str, is_xhtml) {
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function loadFile(fileId) {
	getE('fileId').value = fileId;
	for (var i=0; i<=50; i++) {
		var fileName = getE('fileName_' + fileId).value;
	}
    var xhr;

	if (window.XMLHttpRequest) {
		xhr = new XMLHttpRequest();
	}
	else if (window.ActiveXObject) {
		try {
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {}
		}
	}
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			var new_file= {id: fileId, text: xhr.responseText, syntax: 'css', title: fileName};
			editAreaLoader.openFile('contentCSS', new_file);
			getE('fileName').value = fileName;
		} else if (xhr.readyState == 4 && xhr.status != 200) {
			alert('Une erreur est survenue !\n\nCode :' + xhr.status + '\nTexte : ' + xhr.statusText);
		}
	};
 
   xhr.open("GET", baseDir + fileName + '?nocache=' + Math.random(), true);
   xhr.send(null);
}

function linkEdit(linkId) {
	getE('id').value = linkId;
	var fc = parseInt(getE('languageNb').value - 1);
	for (var i=0; i<=fc; i++) {
		getE('titleInput_' + links[linkId][i * 4]).value = links[linkId][i * 4 + 1];
		getE('urlInput_' + links[linkId][i * 4]).value = links[linkId][i * 4 + 2];
		getE('positionInput_' + links[linkId][i * 4]).value = links[linkId][i * 4 + 3];
	}
	if (document.all) {
		getE('submitAddLink').style.setAttribute('cssText', 'display:none');
		getE('submitEditLink').style.setAttribute('cssText', 'display:block');
	}
	getE('submitAddLink').setAttribute('style', 'display:none');
	getE('submitEditLink').setAttribute('style', 'display:block');
}

function linkDelete(linkId) {
	document.location.replace(currentUrl+'&id='+linkId+'&token='+token);
}